/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.jackson2;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdConverter;
import java.io.IOException;
import org.springframework.security.oauth2.client.jackson2.JsonNodeUtils;
import org.springframework.security.oauth2.client.jackson2.StdConverters;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;

final class OAuth2AuthorizationRequestDeserializer
extends JsonDeserializer<OAuth2AuthorizationRequest> {
    private static final StdConverter<JsonNode, AuthorizationGrantType> AUTHORIZATION_GRANT_TYPE_CONVERTER = new StdConverters.AuthorizationGrantTypeConverter();

    OAuth2AuthorizationRequestDeserializer() {
    }

    public OAuth2AuthorizationRequest deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        OAuth2AuthorizationRequest.Builder builder;
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        JsonNode authorizationRequestNode = (JsonNode)mapper.readTree(parser);
        AuthorizationGrantType authorizationGrantType = (AuthorizationGrantType)AUTHORIZATION_GRANT_TYPE_CONVERTER.convert((Object)JsonNodeUtils.findObjectNode(authorizationRequestNode, "authorizationGrantType"));
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)authorizationGrantType)) {
            builder = OAuth2AuthorizationRequest.authorizationCode();
        } else if (AuthorizationGrantType.IMPLICIT.equals((Object)authorizationGrantType)) {
            builder = OAuth2AuthorizationRequest.implicit();
        } else {
            throw new JsonParseException(parser, "Invalid authorizationGrantType");
        }
        return builder.authorizationUri(JsonNodeUtils.findStringValue(authorizationRequestNode, "authorizationUri")).clientId(JsonNodeUtils.findStringValue(authorizationRequestNode, "clientId")).redirectUri(JsonNodeUtils.findStringValue(authorizationRequestNode, "redirectUri")).scopes(JsonNodeUtils.findValue(authorizationRequestNode, "scopes", JsonNodeUtils.SET_TYPE_REFERENCE, mapper)).state(JsonNodeUtils.findStringValue(authorizationRequestNode, "state")).additionalParameters(JsonNodeUtils.findValue(authorizationRequestNode, "additionalParameters", JsonNodeUtils.MAP_TYPE_REFERENCE, mapper)).authorizationRequestUri(JsonNodeUtils.findStringValue(authorizationRequestNode, "authorizationRequestUri")).attributes(JsonNodeUtils.findValue(authorizationRequestNode, "attributes", JsonNodeUtils.MAP_TYPE_REFERENCE, mapper)).build();
    }
}

