/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.oidc.userinfo;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.userinfo.DefaultOAuth2UserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.converter.ClaimConversionService;
import org.springframework.security.oauth2.core.converter.ClaimTypeConverter;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUserAuthority;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OidcUserService
implements OAuth2UserService<OidcUserRequest, OidcUser> {
    private static final String INVALID_USER_INFO_RESPONSE_ERROR_CODE = "invalid_user_info_response";
    private static final Converter<Map<String, Object>, Map<String, Object>> DEFAULT_CLAIM_TYPE_CONVERTER = new ClaimTypeConverter(OidcUserService.createDefaultClaimTypeConverters());
    private Set<String> accessibleScopes = new HashSet<String>(Arrays.asList("profile", "email", "address", "phone"));
    private OAuth2UserService<OAuth2UserRequest, OAuth2User> oauth2UserService = new DefaultOAuth2UserService();
    private Function<ClientRegistration, Converter<Map<String, Object>, Map<String, Object>>> claimTypeConverterFactory = clientRegistration -> DEFAULT_CLAIM_TYPE_CONVERTER;

    public static Map<String, Converter<Object, ?>> createDefaultClaimTypeConverters() {
        Converter<Object, ?> booleanConverter = OidcUserService.getConverter(TypeDescriptor.valueOf(Boolean.class));
        Converter<Object, ?> instantConverter = OidcUserService.getConverter(TypeDescriptor.valueOf(Instant.class));
        HashMap claimTypeConverters = new HashMap();
        claimTypeConverters.put("email_verified", booleanConverter);
        claimTypeConverters.put("phone_number_verified", booleanConverter);
        claimTypeConverters.put("updated_at", instantConverter);
        return claimTypeConverters;
    }

    private static Converter<Object, ?> getConverter(TypeDescriptor targetDescriptor) {
        TypeDescriptor sourceDescriptor = TypeDescriptor.valueOf(Object.class);
        return source -> ClaimConversionService.getSharedInstance().convert(source, sourceDescriptor, targetDescriptor);
    }

    @Override
    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        Assert.notNull((Object)userRequest, (String)"userRequest cannot be null");
        OidcUserInfo userInfo = null;
        if (this.shouldRetrieveUserInfo(userRequest)) {
            OAuth2User oauth2User = this.oauth2UserService.loadUser(userRequest);
            Converter<Map<String, Object>, Map<String, Object>> claimTypeConverter = this.claimTypeConverterFactory.apply(userRequest.getClientRegistration());
            Map claims = claimTypeConverter != null ? (Map)claimTypeConverter.convert((Object)oauth2User.getAttributes()) : (Map)DEFAULT_CLAIM_TYPE_CONVERTER.convert((Object)oauth2User.getAttributes());
            userInfo = new OidcUserInfo(claims);
            if (userInfo.getSubject() == null) {
                OAuth2Error oauth2Error = new OAuth2Error(INVALID_USER_INFO_RESPONSE_ERROR_CODE);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
            if (!userInfo.getSubject().equals(userRequest.getIdToken().getSubject())) {
                OAuth2Error oauth2Error = new OAuth2Error(INVALID_USER_INFO_RESPONSE_ERROR_CODE);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
        }
        LinkedHashSet<Object> authorities = new LinkedHashSet<Object>();
        authorities.add(new OidcUserAuthority(userRequest.getIdToken(), userInfo));
        OAuth2AccessToken token = userRequest.getAccessToken();
        for (String authority : token.getScopes()) {
            authorities.add(new SimpleGrantedAuthority("SCOPE_" + authority));
        }
        String userNameAttributeName = userRequest.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName();
        DefaultOidcUser user = StringUtils.hasText((String)userNameAttributeName) ? new DefaultOidcUser(authorities, userRequest.getIdToken(), userInfo, userNameAttributeName) : new DefaultOidcUser(authorities, userRequest.getIdToken(), userInfo);
        return user;
    }

    private boolean shouldRetrieveUserInfo(OidcUserRequest userRequest) {
        if (StringUtils.isEmpty((Object)userRequest.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUri())) {
            return false;
        }
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)userRequest.getClientRegistration().getAuthorizationGrantType())) {
            return this.accessibleScopes.isEmpty() || CollectionUtils.containsAny((Collection)userRequest.getAccessToken().getScopes(), this.accessibleScopes);
        }
        return false;
    }

    public final void setOauth2UserService(OAuth2UserService<OAuth2UserRequest, OAuth2User> oauth2UserService) {
        Assert.notNull(oauth2UserService, (String)"oauth2UserService cannot be null");
        this.oauth2UserService = oauth2UserService;
    }

    public final void setClaimTypeConverterFactory(Function<ClientRegistration, Converter<Map<String, Object>, Map<String, Object>>> claimTypeConverterFactory) {
        Assert.notNull(claimTypeConverterFactory, (String)"claimTypeConverterFactory cannot be null");
        this.claimTypeConverterFactory = claimTypeConverterFactory;
    }

    public final void setAccessibleScopes(Set<String> accessibleScopes) {
        Assert.notNull(accessibleScopes, (String)"accessibleScopes cannot be null");
        this.accessibleScopes = accessibleScopes;
    }
}

