/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.util.Assert;

public class OAuth2PasswordGrantRequest
extends AbstractOAuth2AuthorizationGrantRequest {
    private final String username;
    private final String password;

    public OAuth2PasswordGrantRequest(ClientRegistration clientRegistration, String username, String password) {
        super(AuthorizationGrantType.PASSWORD, clientRegistration);
        Assert.isTrue((boolean)AuthorizationGrantType.PASSWORD.equals((Object)clientRegistration.getAuthorizationGrantType()), (String)"clientRegistration.authorizationGrantType must be AuthorizationGrantType.PASSWORD");
        Assert.hasText((String)username, (String)"username cannot be empty");
        Assert.hasText((String)password, (String)"password cannot be empty");
        this.username = username;
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

