/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.util.Map;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderProviderConfigurationUtils;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.util.Assert;

public final class JwtDecoders {
    public static JwtDecoder fromOidcIssuerLocation(String oidcIssuerLocation) {
        Assert.hasText((String)oidcIssuerLocation, (String)"oidcIssuerLocation cannot be empty");
        Map<String, Object> configuration = JwtDecoderProviderConfigurationUtils.getConfigurationForOidcIssuerLocation(oidcIssuerLocation);
        return JwtDecoders.withProviderConfiguration(configuration, oidcIssuerLocation);
    }

    public static JwtDecoder fromIssuerLocation(String issuer) {
        Assert.hasText((String)issuer, (String)"issuer cannot be empty");
        Map<String, Object> configuration = JwtDecoderProviderConfigurationUtils.getConfigurationForIssuerLocation(issuer);
        return JwtDecoders.withProviderConfiguration(configuration, issuer);
    }

    private static JwtDecoder withProviderConfiguration(Map<String, Object> configuration, String issuer) {
        JwtDecoderProviderConfigurationUtils.validateIssuer(configuration, issuer);
        OAuth2TokenValidator<Jwt> jwtValidator = JwtValidators.createDefaultWithIssuer(issuer);
        NimbusJwtDecoder jwtDecoder = NimbusJwtDecoder.withJwkSetUri(configuration.get("jwks_uri").toString()).build();
        jwtDecoder.setJwtValidator(jwtValidator);
        return jwtDecoder;
    }

    private JwtDecoders() {
    }
}

