/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import java.security.Key;
import java.util.Arrays;
import java.util.List;
import org.springframework.security.oauth2.jwt.BadJwtException;
import org.springframework.util.Assert;

final class SingleKeyJWSKeySelector<C extends SecurityContext>
implements JWSKeySelector<C> {
    private final List<Key> keySet;
    private final JWSAlgorithm expectedJwsAlgorithm;

    SingleKeyJWSKeySelector(JWSAlgorithm expectedJwsAlgorithm, Key key) {
        Assert.notNull((Object)expectedJwsAlgorithm, (String)"expectedJwsAlgorithm cannot be null");
        Assert.notNull((Object)key, (String)"key cannot be null");
        this.keySet = Arrays.asList(key);
        this.expectedJwsAlgorithm = expectedJwsAlgorithm;
    }

    public List<? extends Key> selectJWSKeys(JWSHeader header, C context) {
        if (!this.expectedJwsAlgorithm.equals((Object)header.getAlgorithm())) {
            throw new BadJwtException("Unsupported algorithm of " + header.getAlgorithm());
        }
        return this.keySet;
    }
}

