/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.web.reactive.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;
import org.springframework.security.web.server.csrf.CsrfWebFilter;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.test.web.reactive.server.MockServerConfigurer;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.test.web.reactive.server.WebTestClientConfigurer;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;
import reactor.core.publisher.Mono;

public class SecurityMockServerConfigurers {
    public static MockServerConfigurer springSecurity() {
        return new MockServerConfigurer(){

            public void beforeServerCreated(WebHttpHandlerBuilder builder) {
                builder.filters(filters -> filters.add(0, new MutatorFilter()));
            }
        };
    }

    public static <T extends WebTestClientConfigurer & MockServerConfigurer> T mockAuthentication(Authentication authentication) {
        return (T)new MutatorWebTestClientConfigurer(() -> Mono.just((Object)authentication).map(SecurityContextImpl::new));
    }

    public static <T extends WebTestClientConfigurer & MockServerConfigurer> T mockUser(UserDetails userDetails) {
        return SecurityMockServerConfigurers.mockAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)userDetails, (Object)userDetails.getPassword(), userDetails.getAuthorities()));
    }

    public static UserExchangeMutator mockUser() {
        return SecurityMockServerConfigurers.mockUser("user");
    }

    public static UserExchangeMutator mockUser(String username) {
        return new UserExchangeMutator(username);
    }

    public static JwtMutator mockJwt() {
        return SecurityMockServerConfigurers.mockJwt((Jwt.Builder jwt) -> {});
    }

    public static JwtMutator mockJwt(Consumer<Jwt.Builder> jwtBuilderConsumer) {
        Jwt.Builder jwtBuilder = Jwt.withTokenValue((String)"token").header("alg", (Object)"none").claim("sub", (Object)"user").claim("scope", (Object)"read");
        jwtBuilderConsumer.accept(jwtBuilder);
        return new JwtMutator(jwtBuilder.build());
    }

    public static JwtMutator mockJwt(Jwt jwt) {
        return new JwtMutator(jwt);
    }

    public static CsrfMutator csrf() {
        return new CsrfMutator();
    }

    public static class JwtMutator
    implements WebTestClientConfigurer,
    MockServerConfigurer {
        private Jwt jwt;
        private Collection<GrantedAuthority> authorities;

        private JwtMutator(Jwt jwt) {
            this.jwt = jwt;
            this.authorities = new JwtGrantedAuthoritiesConverter().convert(jwt);
        }

        public JwtMutator authorities(Collection<GrantedAuthority> authorities) {
            Assert.notNull(authorities, (String)"authorities cannot be null");
            this.authorities = authorities;
            return this;
        }

        public JwtMutator authorities(GrantedAuthority ... authorities) {
            Assert.notNull((Object)authorities, (String)"authorities cannot be null");
            this.authorities = Arrays.asList(authorities);
            return this;
        }

        public JwtMutator authorities(Converter<Jwt, Collection<GrantedAuthority>> authoritiesConverter) {
            Assert.notNull(authoritiesConverter, (String)"authoritiesConverter cannot be null");
            this.authorities = (Collection)authoritiesConverter.convert((Object)this.jwt);
            return this;
        }

        public void beforeServerCreated(WebHttpHandlerBuilder builder) {
            ((MockServerConfigurer)this.configurer()).beforeServerCreated(builder);
        }

        public void afterConfigureAdded(WebTestClient.MockServerSpec<?> serverSpec) {
            ((MockServerConfigurer)this.configurer()).afterConfigureAdded(serverSpec);
        }

        public void afterConfigurerAdded(WebTestClient.Builder builder, @Nullable WebHttpHandlerBuilder httpHandlerBuilder, @Nullable ClientHttpConnector connector) {
            httpHandlerBuilder.filter(new WebFilter[]{(exchange, chain) -> {
                CsrfWebFilter.skipExchange((ServerWebExchange)exchange);
                return chain.filter(exchange);
            }});
            ((WebTestClientConfigurer)((MockServerConfigurer)this.configurer())).afterConfigurerAdded(builder, httpHandlerBuilder, connector);
        }

        private <T extends WebTestClientConfigurer & MockServerConfigurer> T configurer() {
            return SecurityMockServerConfigurers.mockAuthentication((Authentication)new JwtAuthenticationToken(this.jwt, this.authorities));
        }
    }

    private static class MutatorFilter
    implements WebFilter {
        public static final String ATTRIBUTE_NAME = "context";

        private MutatorFilter() {
        }

        public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain webFilterChain) {
            Supplier context = (Supplier)exchange.getAttribute(ATTRIBUTE_NAME);
            if (context != null) {
                exchange.getAttributes().remove(ATTRIBUTE_NAME);
                return webFilterChain.filter(exchange).subscriberContext(ReactiveSecurityContextHolder.withSecurityContext((Mono)((Mono)context.get())));
            }
            return webFilterChain.filter(exchange);
        }
    }

    private static class SetupMutatorFilter
    implements WebFilter {
        private final Supplier<Mono<SecurityContext>> context;

        private SetupMutatorFilter(Supplier<Mono<SecurityContext>> context) {
            this.context = context;
        }

        public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain webFilterChain) {
            exchange.getAttributes().computeIfAbsent("context", key -> this.context);
            return webFilterChain.filter(exchange);
        }
    }

    private static class MutatorWebTestClientConfigurer
    implements WebTestClientConfigurer,
    MockServerConfigurer {
        private final Supplier<Mono<SecurityContext>> context;

        private MutatorWebTestClientConfigurer(Supplier<Mono<SecurityContext>> context) {
            this.context = context;
        }

        public void beforeServerCreated(WebHttpHandlerBuilder builder) {
            builder.filters(this.addSetupMutatorFilter());
        }

        public void afterConfigurerAdded(WebTestClient.Builder builder, @Nullable WebHttpHandlerBuilder webHttpHandlerBuilder, @Nullable ClientHttpConnector clientHttpConnector) {
            webHttpHandlerBuilder.filters(this.addSetupMutatorFilter());
        }

        private Consumer<List<WebFilter>> addSetupMutatorFilter() {
            return filters -> filters.add(0, new SetupMutatorFilter(this.context));
        }
    }

    public static class UserExchangeMutator
    implements WebTestClientConfigurer,
    MockServerConfigurer {
        private final User.UserBuilder userBuilder;

        private UserExchangeMutator(String username) {
            this.userBuilder = User.withUsername((String)username);
            this.password("password");
            this.roles("USER");
        }

        public UserExchangeMutator password(String password) {
            this.userBuilder.password(password);
            return this;
        }

        public UserExchangeMutator roles(String ... roles) {
            this.userBuilder.roles(roles);
            return this;
        }

        public UserExchangeMutator authorities(GrantedAuthority ... authorities) {
            this.userBuilder.authorities(authorities);
            return this;
        }

        public UserExchangeMutator authorities(Collection<? extends GrantedAuthority> authorities) {
            this.userBuilder.authorities(authorities);
            return this;
        }

        public UserExchangeMutator authorities(String ... authorities) {
            this.userBuilder.authorities(authorities);
            return this;
        }

        public UserExchangeMutator accountExpired(boolean accountExpired) {
            this.userBuilder.accountExpired(accountExpired);
            return this;
        }

        public UserExchangeMutator accountLocked(boolean accountLocked) {
            this.userBuilder.accountLocked(accountLocked);
            return this;
        }

        public UserExchangeMutator credentialsExpired(boolean credentialsExpired) {
            this.userBuilder.credentialsExpired(credentialsExpired);
            return this;
        }

        public UserExchangeMutator disabled(boolean disabled) {
            this.userBuilder.disabled(disabled);
            return this;
        }

        public void beforeServerCreated(WebHttpHandlerBuilder builder) {
            ((MockServerConfigurer)this.configurer()).beforeServerCreated(builder);
        }

        public void afterConfigureAdded(WebTestClient.MockServerSpec<?> serverSpec) {
            ((MockServerConfigurer)this.configurer()).afterConfigureAdded(serverSpec);
        }

        public void afterConfigurerAdded(WebTestClient.Builder builder, @Nullable WebHttpHandlerBuilder webHttpHandlerBuilder, @Nullable ClientHttpConnector clientHttpConnector) {
            ((WebTestClientConfigurer)((MockServerConfigurer)this.configurer())).afterConfigurerAdded(builder, webHttpHandlerBuilder, clientHttpConnector);
        }

        private <T extends WebTestClientConfigurer & MockServerConfigurer> T configurer() {
            return SecurityMockServerConfigurers.mockUser(this.userBuilder.build());
        }
    }

    public static class CsrfMutator
    implements WebTestClientConfigurer,
    MockServerConfigurer {
        public void afterConfigurerAdded(WebTestClient.Builder builder, @Nullable WebHttpHandlerBuilder httpHandlerBuilder, @Nullable ClientHttpConnector connector) {
            CsrfWebFilter filter = new CsrfWebFilter();
            filter.setRequireCsrfProtectionMatcher(e -> ServerWebExchangeMatcher.MatchResult.notMatch());
            httpHandlerBuilder.filters(filters -> filters.add(0, filter));
        }

        public void afterConfigureAdded(WebTestClient.MockServerSpec<?> serverSpec) {
        }

        public void beforeServerCreated(WebHttpHandlerBuilder builder) {
        }

        private CsrfMutator() {
        }
    }
}

