/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.api;

import org.springframework.security.web.webauthn.api.AuthenticationExtensionsClientOutputs;
import org.springframework.security.web.webauthn.api.AuthenticatorAttachment;
import org.springframework.security.web.webauthn.api.AuthenticatorResponse;
import org.springframework.security.web.webauthn.api.Bytes;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialType;

public final class PublicKeyCredential<R extends AuthenticatorResponse> {
    private final String id;
    private final PublicKeyCredentialType type;
    private final Bytes rawId;
    private final R response;
    private final AuthenticatorAttachment authenticatorAttachment;
    private final AuthenticationExtensionsClientOutputs clientExtensionResults;

    private PublicKeyCredential(String id, PublicKeyCredentialType type, Bytes rawId, R response, AuthenticatorAttachment authenticatorAttachment, AuthenticationExtensionsClientOutputs clientExtensionResults) {
        this.id = id;
        this.type = type;
        this.rawId = rawId;
        this.response = response;
        this.authenticatorAttachment = authenticatorAttachment;
        this.clientExtensionResults = clientExtensionResults;
    }

    public String getId() {
        return this.id;
    }

    public PublicKeyCredentialType getType() {
        return this.type;
    }

    public Bytes getRawId() {
        return this.rawId;
    }

    public R getResponse() {
        return this.response;
    }

    public AuthenticatorAttachment getAuthenticatorAttachment() {
        return this.authenticatorAttachment;
    }

    public AuthenticationExtensionsClientOutputs getClientExtensionResults() {
        return this.clientExtensionResults;
    }

    public static <T extends AuthenticatorResponse> PublicKeyCredentialBuilder<T> builder() {
        return new PublicKeyCredentialBuilder();
    }

    public static final class PublicKeyCredentialBuilder<R extends AuthenticatorResponse> {
        private String id;
        private PublicKeyCredentialType type;
        private Bytes rawId;
        private R response;
        private AuthenticatorAttachment authenticatorAttachment;
        private AuthenticationExtensionsClientOutputs clientExtensionResults;

        private PublicKeyCredentialBuilder() {
        }

        public PublicKeyCredentialBuilder id(String id) {
            this.id = id;
            return this;
        }

        public PublicKeyCredentialBuilder type(PublicKeyCredentialType type) {
            this.type = type;
            return this;
        }

        public PublicKeyCredentialBuilder rawId(Bytes rawId) {
            this.rawId = rawId;
            return this;
        }

        public PublicKeyCredentialBuilder response(R response) {
            this.response = response;
            return this;
        }

        public PublicKeyCredentialBuilder authenticatorAttachment(AuthenticatorAttachment authenticatorAttachment) {
            this.authenticatorAttachment = authenticatorAttachment;
            return this;
        }

        public PublicKeyCredentialBuilder clientExtensionResults(AuthenticationExtensionsClientOutputs clientExtensionResults) {
            this.clientExtensionResults = clientExtensionResults;
            return this;
        }

        public PublicKeyCredential<R> build() {
            return new PublicKeyCredential<R>(this.id, this.type, this.rawId, this.response, this.authenticatorAttachment, this.clientExtensionResults);
        }
    }
}

