/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.Delta;
import com.gemstone.gemfire.Instantiator;
import com.gemstone.gemfire.InvalidDeltaException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.gemfire.GemfireAccessor;
import org.springframework.data.gemfire.GemfireOperations;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.session.ExpiringSession;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.data.gemfire.config.annotation.web.http.GemFireHttpSessionConfiguration;
import org.springframework.session.events.SessionCreatedEvent;
import org.springframework.session.events.SessionDeletedEvent;
import org.springframework.session.events.SessionDestroyedEvent;
import org.springframework.session.events.SessionExpiredEvent;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGemFireOperationsSessionRepository
extends CacheListenerAdapter<Object, ExpiringSession>
implements InitializingBean,
FindByIndexNameSessionRepository<ExpiringSession>,
ApplicationEventPublisherAware {
    private int maxInactiveIntervalInSeconds = GemFireHttpSessionConfiguration.DEFAULT_MAX_INACTIVE_INTERVAL_IN_SECONDS;
    private ApplicationEventPublisher applicationEventPublisher = new ApplicationEventPublisher(){

        public void publishEvent(ApplicationEvent event) {
        }

        public void publishEvent(Object event) {
        }
    };
    private final GemfireOperations template;
    protected final Log logger = this.newLogger();
    private String fullyQualifiedRegionName;

    public AbstractGemFireOperationsSessionRepository(GemfireOperations template) {
        Assert.notNull((Object)template, (String)"GemfireOperations must not be null");
        this.template = template;
    }

    Log newLogger() {
        return LogFactory.getLog(this.getClass());
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        Assert.notNull((Object)applicationEventPublisher, (String)"ApplicationEventPublisher must not be null");
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    protected String getFullyQualifiedRegionName() {
        return this.fullyQualifiedRegionName;
    }

    public void setMaxInactiveIntervalInSeconds(int maxInactiveIntervalInSeconds) {
        this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
    }

    public int getMaxInactiveIntervalInSeconds() {
        return this.maxInactiveIntervalInSeconds;
    }

    public GemfireOperations getTemplate() {
        return this.template;
    }

    public void afterPropertiesSet() throws Exception {
        GemfireOperations template = this.getTemplate();
        Assert.isInstanceOf(GemfireAccessor.class, (Object)template);
        Region region = ((GemfireAccessor)template).getRegion();
        this.fullyQualifiedRegionName = region.getFullPath();
        region.getAttributesMutator().addCacheListener((CacheListener)this);
        Instantiator.register((Instantiator)GemFireSessionInstantiator.create());
        Instantiator.register((Instantiator)GemFireSessionAttributesInstantiator.create());
    }

    boolean isExpiringSessionOrNull(Object obj) {
        return obj == null || obj instanceof ExpiringSession;
    }

    ExpiringSession toExpiringSession(Object obj) {
        return obj instanceof ExpiringSession ? (ExpiringSession)obj : null;
    }

    public void afterCreate(EntryEvent<Object, ExpiringSession> event) {
        if (this.isExpiringSessionOrNull(event.getNewValue())) {
            this.handleCreated(event.getKey().toString(), this.toExpiringSession(event.getNewValue()));
        }
    }

    public void afterDestroy(EntryEvent<Object, ExpiringSession> event) {
        this.handleDestroyed(event.getKey().toString(), this.toExpiringSession(event.getOldValue()));
    }

    public void afterInvalidate(EntryEvent<Object, ExpiringSession> event) {
        this.handleExpired(event.getKey().toString(), this.toExpiringSession(event.getOldValue()));
    }

    protected void handleCreated(String sessionId, ExpiringSession session) {
        this.publishEvent(session != null ? new SessionCreatedEvent((Object)this, session) : new SessionCreatedEvent((Object)this, sessionId));
    }

    protected void handleDeleted(String sessionId, ExpiringSession session) {
        this.publishEvent(session != null ? new SessionDeletedEvent((Object)this, session) : new SessionDeletedEvent((Object)this, sessionId));
    }

    protected void handleDestroyed(String sessionId, ExpiringSession session) {
        this.publishEvent(session != null ? new SessionDestroyedEvent((Object)this, session) : new SessionDestroyedEvent((Object)this, sessionId));
    }

    protected void handleExpired(String sessionId, ExpiringSession session) {
        this.publishEvent(session != null ? new SessionExpiredEvent((Object)this, session) : new SessionExpiredEvent((Object)this, sessionId));
    }

    protected void publishEvent(ApplicationEvent event) {
        try {
            this.getApplicationEventPublisher().publishEvent(event);
        }
        catch (Throwable t) {
            this.logger.error((Object)String.format("error occurred publishing event (%1$s)", event), t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GemFireSessionAttributesInstantiator
    extends Instantiator {
        public static GemFireSessionAttributesInstantiator create() {
            return new GemFireSessionAttributesInstantiator(GemFireSessionAttributes.class, 800828008);
        }

        public GemFireSessionAttributesInstantiator(Class<? extends DataSerializable> type, int id) {
            super(type, id);
        }

        public DataSerializable newInstance() {
            return new GemFireSessionAttributes();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GemFireSessionAttributes
    extends AbstractMap<String, Object>
    implements DataSerializable,
    Delta {
        protected static final boolean DEFAULT_ALLOW_JAVA_SERIALIZATION = true;
        private final transient Map<String, Object> sessionAttributes = new HashMap<String, Object>();
        private final transient Map<String, Object> sessionAttributeDeltas = new HashMap<String, Object>();
        private final transient Object lock;

        protected GemFireSessionAttributes() {
            this.lock = this;
        }

        protected GemFireSessionAttributes(Object lock) {
            this.lock = lock != null ? lock : this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAttribute(String attributeName, Object attributeValue) {
            Object object = this.lock;
            synchronized (object) {
                if (attributeValue != null) {
                    if (!attributeValue.equals(this.sessionAttributes.put(attributeName, attributeValue))) {
                        this.sessionAttributeDeltas.put(attributeName, attributeValue);
                    }
                } else {
                    this.removeAttribute(attributeName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAttribute(String attributeName) {
            Object object = this.lock;
            synchronized (object) {
                if (this.sessionAttributes.remove(attributeName) != null) {
                    this.sessionAttributeDeltas.put(attributeName, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T getAttribute(String attributeName) {
            Object object = this.lock;
            synchronized (object) {
                return (T)this.sessionAttributes.get(attributeName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<String> getAttributeNames() {
            Object object = this.lock;
            synchronized (object) {
                return Collections.unmodifiableSet(new HashSet<String>(this.sessionAttributes.keySet()));
            }
        }

        protected boolean allowJavaSerialization() {
            return true;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return new AbstractSet<Map.Entry<String, Object>>(){

                @Override
                public Iterator<Map.Entry<String, Object>> iterator() {
                    return Collections.unmodifiableMap(GemFireSessionAttributes.this.sessionAttributes).entrySet().iterator();
                }

                @Override
                public int size() {
                    return GemFireSessionAttributes.this.sessionAttributes.size();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void from(Session session) {
            Object object = this.lock;
            synchronized (object) {
                for (String attributeName : session.getAttributeNames()) {
                    this.setAttribute(attributeName, session.getAttribute(attributeName));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void from(GemFireSessionAttributes sessionAttributes) {
            Object object = this.lock;
            synchronized (object) {
                for (String attributeName : sessionAttributes.getAttributeNames()) {
                    this.setAttribute(attributeName, sessionAttributes.getAttribute(attributeName));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void toData(DataOutput out) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                Set<String> attributeNames = this.getAttributeNames();
                out.writeInt(attributeNames.size());
                for (String attributeName : attributeNames) {
                    out.writeUTF(attributeName);
                    this.writeObject(this.getAttribute(attributeName), out);
                }
            }
        }

        void writeObject(Object obj, DataOutput out) throws IOException {
            DataSerializer.writeObject((Object)obj, (DataOutput)out, (boolean)this.allowJavaSerialization());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            Object object = this.lock;
            synchronized (object) {
                for (int count = in.readInt(); count > 0; --count) {
                    this.setAttribute(in.readUTF(), this.readObject(in));
                }
                this.sessionAttributeDeltas.clear();
            }
        }

        <T> T readObject(DataInput in) throws ClassNotFoundException, IOException {
            return (T)DataSerializer.readObject((DataInput)in);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasDelta() {
            Object object = this.lock;
            synchronized (object) {
                return !this.sessionAttributeDeltas.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void toDelta(DataOutput out) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                out.writeInt(this.sessionAttributeDeltas.size());
                for (Map.Entry<String, Object> entry : this.sessionAttributeDeltas.entrySet()) {
                    out.writeUTF(entry.getKey());
                    this.writeObject(entry.getValue(), out);
                }
                this.sessionAttributeDeltas.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fromDelta(DataInput in) throws InvalidDeltaException, IOException {
            Object object = this.lock;
            synchronized (object) {
                try {
                    int count = in.readInt();
                    HashMap deltas = new HashMap(count);
                    while (count-- > 0) {
                        deltas.put(in.readUTF(), this.readObject(in));
                    }
                    for (Map.Entry entry : deltas.entrySet()) {
                        this.setAttribute((String)entry.getKey(), entry.getValue());
                        this.sessionAttributeDeltas.remove(entry.getKey());
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new InvalidDeltaException("class type in data not found", (Throwable)e);
                }
            }
        }

        @Override
        public String toString() {
            return this.sessionAttributes.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GemFireSessionInstantiator
    extends Instantiator {
        public static GemFireSessionInstantiator create() {
            return new GemFireSessionInstantiator(GemFireSession.class, 800813552);
        }

        public GemFireSessionInstantiator(Class<? extends DataSerializable> type, int id) {
            super(type, id);
        }

        public DataSerializable newInstance() {
            return new GemFireSession();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GemFireSession
    implements Comparable<ExpiringSession>,
    DataSerializable,
    Delta,
    ExpiringSession {
        protected static final boolean DEFAULT_ALLOW_JAVA_SERIALIZATION = true;
        protected static final DateFormat TO_STRING_DATE_FORMAT = new SimpleDateFormat("YYYY-MM-dd-HH-mm-ss");
        protected static final String SPRING_SECURITY_CONTEXT = "SPRING_SECURITY_CONTEXT";
        private transient boolean delta = false;
        private int maxInactiveIntervalInSeconds;
        private long creationTime;
        private long lastAccessedTime;
        private final transient GemFireSessionAttributes sessionAttributes = new GemFireSessionAttributes(this);
        private final transient SpelExpressionParser parser = new SpelExpressionParser();
        private String id;

        protected GemFireSession() {
            this(UUID.randomUUID().toString());
        }

        protected GemFireSession(String id) {
            this.id = this.validateId(id);
            this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
        }

        protected GemFireSession(ExpiringSession session) {
            Assert.notNull((Object)session, (String)"The ExpiringSession to copy cannot be null");
            this.id = session.getId();
            this.creationTime = session.getCreationTime();
            this.lastAccessedTime = session.getLastAccessedTime();
            this.maxInactiveIntervalInSeconds = session.getMaxInactiveIntervalInSeconds();
            this.sessionAttributes.from(session);
        }

        public static GemFireSession create(int maxInactiveIntervalInSeconds) {
            GemFireSession session = new GemFireSession();
            session.setMaxInactiveIntervalInSeconds(maxInactiveIntervalInSeconds);
            return session;
        }

        public static GemFireSession from(ExpiringSession expiringSession) {
            GemFireSession session = new GemFireSession(expiringSession);
            session.setLastAccessedTime(System.currentTimeMillis());
            return session;
        }

        private String validateId(String id) {
            Assert.hasText((String)id, (String)"ID must be specified");
            return id;
        }

        protected boolean allowJavaSerialization() {
            return true;
        }

        @Override
        public synchronized String getId() {
            return this.id;
        }

        @Override
        public synchronized long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public void setAttribute(String attributeName, Object attributeValue) {
            this.sessionAttributes.setAttribute(attributeName, attributeValue);
        }

        @Override
        public void removeAttribute(String attributeName) {
            this.sessionAttributes.removeAttribute(attributeName);
        }

        @Override
        public <T> T getAttribute(String attributeName) {
            return this.sessionAttributes.getAttribute(attributeName);
        }

        @Override
        public Set<String> getAttributeNames() {
            return this.sessionAttributes.getAttributeNames();
        }

        public GemFireSessionAttributes getAttributes() {
            return this.sessionAttributes;
        }

        @Override
        public synchronized boolean isExpired() {
            long lastAccessedTime = this.getLastAccessedTime();
            long maxInactiveIntervalInSeconds = this.getMaxInactiveIntervalInSeconds();
            return maxInactiveIntervalInSeconds >= 0L && this.idleTimeout(maxInactiveIntervalInSeconds) >= lastAccessedTime;
        }

        private long idleTimeout(long maxInactiveIntervalInSeconds) {
            return System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(maxInactiveIntervalInSeconds);
        }

        @Override
        public synchronized void setLastAccessedTime(long lastAccessedTime) {
            this.delta |= this.lastAccessedTime != lastAccessedTime;
            this.lastAccessedTime = lastAccessedTime;
        }

        @Override
        public synchronized long getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        @Override
        public synchronized void setMaxInactiveIntervalInSeconds(int maxInactiveIntervalInSeconds) {
            this.delta |= this.maxInactiveIntervalInSeconds != maxInactiveIntervalInSeconds;
            this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
        }

        @Override
        public synchronized int getMaxInactiveIntervalInSeconds() {
            return this.maxInactiveIntervalInSeconds;
        }

        public synchronized void setPrincipalName(String principalName) {
            this.setAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, principalName);
        }

        public synchronized String getPrincipalName() {
            Object authentication;
            String principalName = (String)this.getAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME);
            if (principalName == null && (authentication = this.getAttribute(SPRING_SECURITY_CONTEXT)) != null) {
                Expression expression = this.parser.parseExpression("authentication?.name");
                principalName = (String)expression.getValue(authentication, String.class);
            }
            return principalName;
        }

        public synchronized void toData(DataOutput out) throws IOException {
            out.writeUTF(this.getId());
            out.writeLong(this.getCreationTime());
            out.writeLong(this.getLastAccessedTime());
            out.writeInt(this.getMaxInactiveIntervalInSeconds());
            String principalName = this.getPrincipalName();
            int length = StringUtils.hasText((String)principalName) ? principalName.length() : 0;
            out.writeInt(length);
            if (length > 0) {
                out.writeUTF(principalName);
            }
            this.writeObject(this.sessionAttributes, out);
            this.delta = false;
        }

        void writeObject(Object obj, DataOutput out) throws IOException {
            DataSerializer.writeObject((Object)obj, (DataOutput)out, (boolean)this.allowJavaSerialization());
        }

        public synchronized void fromData(DataInput in) throws ClassNotFoundException, IOException {
            this.id = in.readUTF();
            this.creationTime = in.readLong();
            this.setLastAccessedTime(in.readLong());
            this.setMaxInactiveIntervalInSeconds(in.readInt());
            int principalNameLength = in.readInt();
            if (principalNameLength > 0) {
                this.setPrincipalName(in.readUTF());
            }
            this.sessionAttributes.from((GemFireSessionAttributes)this.readObject(in));
            this.delta = false;
        }

        <T> T readObject(DataInput in) throws ClassNotFoundException, IOException {
            return (T)DataSerializer.readObject((DataInput)in);
        }

        public synchronized boolean hasDelta() {
            return this.delta || this.sessionAttributes.hasDelta();
        }

        public synchronized void toDelta(DataOutput out) throws IOException {
            out.writeLong(this.getLastAccessedTime());
            out.writeInt(this.getMaxInactiveIntervalInSeconds());
            this.sessionAttributes.toDelta(out);
            this.delta = false;
        }

        public synchronized void fromDelta(DataInput in) throws IOException {
            this.setLastAccessedTime(in.readLong());
            this.setMaxInactiveIntervalInSeconds(in.readInt());
            this.sessionAttributes.fromDelta(in);
            this.delta = false;
        }

        @Override
        public int compareTo(ExpiringSession session) {
            return Long.valueOf(this.getCreationTime()).compareTo(session.getCreationTime());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Session)) {
                return false;
            }
            Session that = (Session)obj;
            return this.getId().equals(that.getId());
        }

        public int hashCode() {
            int hashValue = 17;
            hashValue = 37 * hashValue + this.getId().hashCode();
            return hashValue;
        }

        public synchronized String toString() {
            return String.format("{ @type = %1$s, id = %2$s, creationTime = %3$s, lastAccessedTime = %4$s, maxInactiveIntervalInSeconds = %5$s, principalName = %6$s }", this.getClass().getName(), this.getId(), this.toString(this.getCreationTime()), this.toString(this.getLastAccessedTime()), this.getMaxInactiveIntervalInSeconds(), this.getPrincipalName());
        }

        private String toString(long timestamp) {
            return TO_STRING_DATE_FORMAT.format(new Date(timestamp));
        }
    }
}

