/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.table;

import java.util.ArrayList;
import java.util.List;
import org.springframework.shell.table.TableModel;
import org.springframework.util.Assert;

public class TableModelBuilder<T> {
    public static final int DEFAULT_ROW_CAPACITY = 3;
    private List<List<T>> rows = new ArrayList<List<T>>();
    private int previousRowSize = -1;
    private boolean frozen;

    public TableModelBuilder<T> addRow() {
        Assert.isTrue((!this.frozen ? 1 : 0) != 0, (String)"TableModel has already been built, builder can't be altered anymore");
        int nbRows = this.rows.size();
        if (this.previousRowSize != -1) {
            int currentRowSize = this.rows.get(nbRows - 1).size();
            Assert.isTrue((currentRowSize == this.previousRowSize ? 1 : 0) != 0, (String)"Can't switch to next row, as the current one does not have as many elements as the previous one");
        }
        if (this.rows.size() > 0) {
            this.previousRowSize = this.rows.get(0).size();
        }
        this.rows.add(new ArrayList(this.previousRowSize == -1 ? 3 : this.previousRowSize));
        return this;
    }

    public TableModelBuilder<T> addValue(T value) {
        Assert.isTrue((!this.frozen ? 1 : 0) != 0, (String)"TableModel has already been built, builder can't be altered anymore");
        if (this.previousRowSize != -1 && this.rows.get(this.rows.size() - 1).size() == this.previousRowSize) {
            throw new IllegalArgumentException("Can't add another value to current row");
        }
        this.rows.get(this.rows.size() - 1).add(value);
        return this;
    }

    public TableModel build() {
        this.frozen = true;
        return new TableModel(){

            @Override
            public int getRowCount() {
                return TableModelBuilder.this.rows.size();
            }

            @Override
            public int getColumnCount() {
                return TableModelBuilder.this.rows.isEmpty() ? 0 : ((List)TableModelBuilder.this.rows.get(0)).size();
            }

            @Override
            public Object getValue(int row, int column) {
                return ((List)TableModelBuilder.this.rows.get(row)).get(column);
            }
        };
    }
}

