/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.aot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.aot.AotException;
import org.springframework.beans.factory.aot.AotProcessingException;
import org.springframework.beans.factory.aot.AotServices;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.aot.RuntimeHintsBeanFactoryInitializationAotProcessor;

class BeanFactoryInitializationAotContributions {
    private final List<BeanFactoryInitializationAotContribution> contributions;

    BeanFactoryInitializationAotContributions(DefaultListableBeanFactory beanFactory) {
        this(beanFactory, AotServices.factoriesAndBeans((ListableBeanFactory)beanFactory));
    }

    BeanFactoryInitializationAotContributions(DefaultListableBeanFactory beanFactory, AotServices.Loader loader) {
        this.contributions = this.getContributions(beanFactory, BeanFactoryInitializationAotContributions.getProcessors(loader));
    }

    private static List<BeanFactoryInitializationAotProcessor> getProcessors(AotServices.Loader loader) {
        ArrayList<RuntimeHintsBeanFactoryInitializationAotProcessor> processors = new ArrayList<RuntimeHintsBeanFactoryInitializationAotProcessor>(loader.load(BeanFactoryInitializationAotProcessor.class).asList());
        processors.add(new RuntimeHintsBeanFactoryInitializationAotProcessor());
        return Collections.unmodifiableList(processors);
    }

    private List<BeanFactoryInitializationAotContribution> getContributions(DefaultListableBeanFactory beanFactory, List<BeanFactoryInitializationAotProcessor> processors) {
        ArrayList<BeanFactoryInitializationAotContribution> contributions = new ArrayList<BeanFactoryInitializationAotContribution>();
        for (BeanFactoryInitializationAotProcessor processor : processors) {
            BeanFactoryInitializationAotContribution contribution = this.processAheadOfTime(processor, beanFactory);
            if (contribution == null) continue;
            contributions.add(contribution);
        }
        return Collections.unmodifiableList(contributions);
    }

    private @Nullable BeanFactoryInitializationAotContribution processAheadOfTime(BeanFactoryInitializationAotProcessor processor, DefaultListableBeanFactory beanFactory) {
        try {
            return processor.processAheadOfTime((ConfigurableListableBeanFactory)beanFactory);
        }
        catch (AotException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AotProcessingException("Error executing '" + processor.getClass().getName() + "': " + ex.getMessage(), (Throwable)ex);
        }
    }

    void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
        for (BeanFactoryInitializationAotContribution contribution : this.contributions) {
            contribution.applyTo(generationContext, beanFactoryInitializationCode);
        }
    }
}

