/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.resilience.retry;

import java.lang.reflect.Method;
import java.time.Duration;
import java.util.concurrent.Future;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.retry.RetryException;
import org.springframework.core.retry.RetryPolicy;
import org.springframework.core.retry.RetryTemplate;
import org.springframework.core.retry.Retryable;
import org.springframework.resilience.retry.MethodRetrySpec;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

public abstract class AbstractRetryInterceptor
implements MethodInterceptor {
    private static final boolean REACTIVE_STREAMS_PRESENT = ClassUtils.isPresent((String)"org.reactivestreams.Publisher", (ClassLoader)AbstractRetryInterceptor.class.getClassLoader());
    private final @Nullable ReactiveAdapterRegistry reactiveAdapterRegistry = REACTIVE_STREAMS_PRESENT ? ReactiveAdapterRegistry.getSharedInstance() : null;

    public @Nullable Object invoke(final MethodInvocation invocation) throws Throwable {
        ReactiveAdapter adapter;
        Object target;
        final Method method = invocation.getMethod();
        MethodRetrySpec spec = this.getRetrySpec(method, (target = invocation.getThis()) != null ? target.getClass() : method.getDeclaringClass());
        if (spec == null) {
            return invocation.proceed();
        }
        if (this.reactiveAdapterRegistry != null && !Future.class.isAssignableFrom(method.getReturnType()) && (adapter = this.reactiveAdapterRegistry.getAdapter(method.getReturnType())) != null) {
            Object result = invocation.proceed();
            if (result == null) {
                return null;
            }
            return ReactorDelegate.adaptReactiveResult(result, adapter, spec, method);
        }
        RetryPolicy retryPolicy = RetryPolicy.builder().includes(spec.includes()).excludes(spec.excludes()).predicate(spec.predicate().forMethod(method)).maxAttempts(spec.maxAttempts()).delay(spec.delay()).jitter(spec.jitter()).multiplier(spec.multiplier()).maxDelay(spec.maxDelay()).build();
        RetryTemplate retryTemplate = new RetryTemplate(retryPolicy);
        try {
            return retryTemplate.execute((Retryable)new Retryable<Object>(){
                final /* synthetic */ AbstractRetryInterceptor this$0;
                {
                    this.this$0 = this$0;
                }

                public @Nullable Object execute() throws Throwable {
                    Object object;
                    if (invocation instanceof ProxyMethodInvocation) {
                        ProxyMethodInvocation pmi = (ProxyMethodInvocation)invocation;
                        object = pmi.invocableClone().proceed();
                    } else {
                        object = invocation.proceed();
                    }
                    return object;
                }

                public String getName() {
                    return ClassUtils.getQualifiedMethodName((Method)method, target != null ? target.getClass() : null);
                }
            });
        }
        catch (RetryException ex) {
            throw ex.getCause();
        }
    }

    protected abstract @Nullable MethodRetrySpec getRetrySpec(Method var1, Class<?> var2);

    private static class ReactorDelegate {
        private ReactorDelegate() {
        }

        public static Object adaptReactiveResult(Object result, ReactiveAdapter adapter, MethodRetrySpec spec, Method method) {
            Publisher publisher = adapter.toPublisher(result);
            RetryBackoffSpec retry = Retry.backoff((long)spec.maxAttempts(), (Duration)spec.delay()).jitter(ReactorDelegate.calculateJitterFactor(spec)).multiplier(spec.multiplier()).maxBackoff(spec.maxDelay()).filter(spec.combinedPredicate().forMethod(method));
            publisher = adapter.isMultiValue() ? Flux.from((Publisher)publisher).retryWhen((Retry)retry) : Mono.from((Publisher)publisher).retryWhen((Retry)retry);
            return adapter.fromPublisher(publisher);
        }

        private static double calculateJitterFactor(MethodRetrySpec spec) {
            return spec.delay().isZero() ? 0.0 : Math.max(0.0, Math.min(1.0, (double)spec.jitter().toNanos() / (double)spec.delay().toNanos()));
        }
    }
}

