/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.request;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.request.Servlet3MockHttpServletRequest;
import org.springframework.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MockAsyncContext
implements AsyncContext {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final List<AsyncListener> listeners = new ArrayList<AsyncListener>();
    private String dispatchedPath;
    private long timeout = 10000L;

    public MockAsyncContext(ServletRequest request, ServletResponse response) {
        this.request = (HttpServletRequest)request;
        this.response = (HttpServletResponse)response;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public boolean hasOriginalRequestAndResponse() {
        return this.request instanceof MockHttpServletRequest && this.response instanceof MockHttpServletResponse;
    }

    public String getDispatchedPath() {
        return this.dispatchedPath;
    }

    public void dispatch() {
        this.dispatch(this.request.getRequestURI());
    }

    public void dispatch(String path) {
        this.dispatch(null, path);
    }

    public void dispatch(ServletContext context, String path) {
        this.dispatchedPath = path;
    }

    public void complete() {
        Servlet3MockHttpServletRequest mockRequest = (Servlet3MockHttpServletRequest)WebUtils.getNativeRequest((ServletRequest)this.request, Servlet3MockHttpServletRequest.class);
        if (mockRequest != null) {
            mockRequest.setAsyncStarted(false);
        }
        for (AsyncListener listener : this.listeners) {
            try {
                listener.onComplete(new AsyncEvent((AsyncContext)this, (ServletRequest)this.request, (ServletResponse)this.response));
            }
            catch (IOException e) {
                throw new IllegalStateException("AsyncListener failure", e);
            }
        }
    }

    public void start(Runnable runnable) {
        runnable.run();
    }

    public List<AsyncListener> getListeners() {
        return this.listeners;
    }

    public void addListener(AsyncListener listener) {
        this.listeners.add(listener);
    }

    public void addListener(AsyncListener listener, ServletRequest request, ServletResponse response) {
        this.listeners.add(listener);
    }

    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        return (T)((AsyncListener)BeanUtils.instantiateClass(clazz));
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

