/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.result.FlashAttributeResultMatchers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\n\u001a\u00020\u000b\"\u0004\b\u0000\u0010\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\f0\u0010J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001J\u001f\u0010\u0012\u001a\u00020\u000b2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0013\"\u00020\u000e\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/springframework/test/web/servlet/result/FlashAttributeResultMatchersDsl;", "", "actions", "Lorg/springframework/test/web/servlet/ResultActions;", "<init>", "(Lorg/springframework/test/web/servlet/ResultActions;)V", "matchers", "Lorg/springframework/test/web/servlet/result/FlashAttributeResultMatchers;", "kotlin.jvm.PlatformType", "Lorg/springframework/test/web/servlet/result/FlashAttributeResultMatchers;", "attribute", "", "T", "name", "", "matcher", "Lorg/hamcrest/Matcher;", "value", "attributeExists", "", "([Ljava/lang/String;)V", "attributeCount", "count", "", "spring-test"})
public final class FlashAttributeResultMatchersDsl {
    @NotNull
    private final ResultActions actions;
    private final FlashAttributeResultMatchers matchers;

    public FlashAttributeResultMatchersDsl(@NotNull ResultActions actions) {
        Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
        this.actions = actions;
        this.matchers = MockMvcResultMatchers.flash();
    }

    public final <T> void attribute(@NotNull String name, @NotNull Matcher<T> matcher) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        this.actions.andExpect(this.matchers.attribute(name, matcher));
    }

    public final void attribute(@NotNull String name, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.actions.andExpect(this.matchers.attribute(name, value));
    }

    public final void attributeExists(String ... name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.actions.andExpect(this.matchers.attributeExists(Arrays.copyOf(name, name.length)));
    }

    public final void attributeCount(int count) {
        this.actions.andExpect(this.matchers.attributeCount(count));
    }
}

