/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import jakarta.servlet.http.Part;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;

public class MockPart
implements Part {
    private final String name;
    private final @Nullable String filename;
    private final byte[] content;
    private final HttpHeaders headers = new HttpHeaders();

    public MockPart(String name, byte @Nullable [] content) {
        this(name, null, content);
    }

    public MockPart(String name, @Nullable String filename, byte @Nullable [] content) {
        this(name, filename, content, null);
    }

    public MockPart(String name, @Nullable String filename, byte @Nullable [] content, @Nullable MediaType contentType) {
        Assert.hasLength((String)name, (String)"'name' must not be empty");
        this.name = name;
        this.filename = filename;
        this.content = content != null ? content : new byte[]{};
        this.headers.setContentDispositionFormData(name, filename);
        this.headers.setContentType(contentType);
    }

    public String getName() {
        return this.name;
    }

    public @Nullable String getSubmittedFileName() {
        return this.filename;
    }

    public @Nullable String getContentType() {
        MediaType contentType = this.headers.getContentType();
        return contentType != null ? contentType.toString() : null;
    }

    public long getSize() {
        return this.content.length;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    public void write(String fileName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void delete() throws IOException {
        throw new UnsupportedOperationException();
    }

    public @Nullable String getHeader(String name) {
        return this.headers.getFirst(name);
    }

    public Collection<String> getHeaders(String name) {
        List<String> headerValues = this.headers.get(name);
        return headerValues != null ? headerValues : Collections.emptyList();
    }

    public Collection<String> getHeaderNames() {
        return this.headers.headerNames();
    }

    public final HttpHeaders getHeaders() {
        return this.headers;
    }
}

