/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.cache;

import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.Assert;

public interface ContextCache {
    public static final String CONTEXT_CACHE_LOGGING_CATEGORY = "org.springframework.test.context.cache";
    public static final int DEFAULT_MAX_CONTEXT_CACHE_SIZE = 32;
    public static final String MAX_CONTEXT_CACHE_SIZE_PROPERTY_NAME = "spring.test.context.cache.maxSize";

    public boolean contains(MergedContextConfiguration var1);

    public @Nullable ApplicationContext get(MergedContextConfiguration var1);

    @Deprecated(since="7.0")
    public void put(MergedContextConfiguration var1, ApplicationContext var2);

    default public ApplicationContext put(MergedContextConfiguration key, LoadFunction loadFunction) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)loadFunction, (String)"LoadFunction must not be null");
        ApplicationContext applicationContext = loadFunction.loadContext(key);
        Assert.state((applicationContext != null ? 1 : 0) != 0, (String)"LoadFunction must return a non-null ApplicationContext");
        this.put(key, applicationContext);
        return applicationContext;
    }

    public void remove(MergedContextConfiguration var1,  @Nullable DirtiesContext.HierarchyMode var2);

    default public int getFailureCount(MergedContextConfiguration key) {
        return 0;
    }

    default public void incrementFailureCount(MergedContextConfiguration key) {
    }

    default public void registerContextUsage(MergedContextConfiguration key, Class<?> testClass) {
    }

    default public void unregisterContextUsage(MergedContextConfiguration key, Class<?> testClass) {
    }

    default public int getContextUsageCount() {
        return 0;
    }

    public int size();

    public int getParentContextCount();

    public int getHitCount();

    public int getMissCount();

    public void reset();

    public void clear();

    public void clearStatistics();

    public void logStatistics();

    @FunctionalInterface
    public static interface LoadFunction {
        public ApplicationContext loadContext(MergedContextConfiguration var1);
    }
}

