/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.upgrade;

import java.security.Principal;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.server.reactive.ReactorServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.ReactorNettyWebSocketSession;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.websocket.WebsocketInbound;
import reactor.ipc.netty.http.websocket.WebsocketOutbound;

public class ReactorNettyRequestUpgradeStrategy
implements RequestUpgradeStrategy {
    @Override
    public Mono<Void> upgrade(ServerWebExchange exchange, WebSocketHandler handler, @Nullable String subProtocol) {
        ReactorServerHttpResponse response = (ReactorServerHttpResponse)exchange.getResponse();
        HandshakeInfo info = this.getHandshakeInfo(exchange, subProtocol);
        NettyDataBufferFactory bufferFactory = (NettyDataBufferFactory)response.bufferFactory();
        return response.getReactorResponse().sendWebsocket(subProtocol, (in, out) -> handler.handle(new ReactorNettyWebSocketSession((WebsocketInbound)in, (WebsocketOutbound)out, info, bufferFactory)));
    }

    private HandshakeInfo getHandshakeInfo(ServerWebExchange exchange, @Nullable String protocol) {
        ServerHttpRequest request = exchange.getRequest();
        Mono principal = exchange.getPrincipal();
        return new HandshakeInfo(request.getURI(), request.getHeaders(), (Mono<Principal>)principal, protocol);
    }
}

