/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.support;

import org.springframework.util.Assert;
import org.springframework.web.reactive.HandlerAdapter;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.server.WebSocketService;
import org.springframework.web.reactive.socket.server.support.HandshakeWebSocketService;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class WebSocketHandlerAdapter
implements HandlerAdapter {
    private final WebSocketService webSocketService;

    public WebSocketHandlerAdapter() {
        this(new HandshakeWebSocketService());
    }

    public WebSocketHandlerAdapter(WebSocketService webSocketService) {
        Assert.notNull((Object)webSocketService, (String)"'webSocketService' is required");
        this.webSocketService = webSocketService;
    }

    public WebSocketService getWebSocketService() {
        return this.webSocketService;
    }

    @Override
    public boolean supports(Object handler) {
        return WebSocketHandler.class.isAssignableFrom(handler.getClass());
    }

    @Override
    public Mono<HandlerResult> handle(ServerWebExchange exchange, Object handler) {
        WebSocketHandler webSocketHandler = (WebSocketHandler)handler;
        return this.getWebSocketService().handleRequest(exchange, webSocketHandler).then(Mono.empty());
    }
}

