/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.data.support;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.core.io.Resource;
import org.springframework.data.repository.init.ResourceReader;
import org.springframework.statemachine.data.BaseRepositoryEntity;
import org.springframework.util.ClassUtils;

public class StateMachineJackson2ResourceReader
implements ResourceReader {
    private static final String DEFAULT_TYPE_KEY = "_class";
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
    private final ObjectMapper mapper;
    private String typeKey = "_class";

    public StateMachineJackson2ResourceReader() {
        this(DEFAULT_MAPPER);
    }

    public StateMachineJackson2ResourceReader(ObjectMapper mapper) {
        this.mapper = mapper == null ? DEFAULT_MAPPER : mapper;
    }

    public void setTypeKey(String typeKey) {
        this.typeKey = typeKey;
    }

    public Object readFrom(Resource resource, ClassLoader classLoader) throws Exception {
        InputStream stream = resource.getInputStream();
        ObjectReader objectReader = this.mapper.readerFor(JsonNode.class);
        JsonNode node = objectReader.readTree(stream);
        objectReader = this.mapper.readerFor(BaseRepositoryEntity[].class);
        if (node.isArray()) {
            ArrayList<BaseRepositoryEntity> result = new ArrayList<BaseRepositoryEntity>();
            BaseRepositoryEntity[] entitys = (BaseRepositoryEntity[])objectReader.readValue(node);
            result.addAll(Arrays.asList(entitys));
            return result;
        }
        return this.readSingle(node, classLoader);
    }

    private Object readSingle(JsonNode node, ClassLoader classLoader) throws IOException {
        JsonNode typeNode = node.findValue(this.typeKey);
        String typeName = typeNode == null ? null : typeNode.asText();
        Class type = ClassUtils.resolveClassName((String)typeName, (ClassLoader)classLoader);
        return this.mapper.readerFor(type).readValue(node);
    }

    static {
        DEFAULT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

