/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class StringKeyedMapAdapter<V>
implements Map<String, V> {
    private Set<String> keySet;
    private Collection<V> values;
    private Set<Map.Entry<String, V>> entrySet;

    @Override
    public void clear() {
        Iterator<String> it = this.getAttributeNames();
        while (it.hasNext()) {
            this.removeAttribute(it.next());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getAttribute(key.toString()) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        Iterator<String> it = this.getAttributeNames();
        while (it.hasNext()) {
            V aValue = this.getAttribute(it.next());
            if (!value.equals(aValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this.entrySet != null ? this.entrySet : (this.entrySet = new EntrySet());
    }

    @Override
    public V get(Object key) {
        return this.getAttribute(key.toString());
    }

    @Override
    public boolean isEmpty() {
        return !this.getAttributeNames().hasNext();
    }

    @Override
    public Set<String> keySet() {
        return this.keySet != null ? this.keySet : (this.keySet = new KeySet());
    }

    @Override
    public V put(String key, V value) {
        String stringKey = String.valueOf(key);
        V previousValue = this.getAttribute(stringKey);
        this.setAttribute(stringKey, value);
        return previousValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> map) {
        for (Map.Entry<String, V> entry : map.entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        String stringKey = key.toString();
        V retval = this.getAttribute(stringKey);
        this.removeAttribute(stringKey);
        return retval;
    }

    @Override
    public int size() {
        int size = 0;
        Iterator<String> it = this.getAttributeNames();
        while (it.hasNext()) {
            ++size;
            it.next();
        }
        return size;
    }

    @Override
    public Collection<V> values() {
        return this.values != null ? this.values : (this.values = new Values());
    }

    protected abstract V getAttribute(String var1);

    protected abstract void setAttribute(String var1, V var2);

    protected abstract void removeAttribute(String var1);

    protected abstract Iterator<String> getAttributeNames();

    private class EntrySetEntry
    implements Map.Entry<String, V> {
        private final String currentKey;

        public EntrySetEntry(String currentKey) {
            this.currentKey = currentKey;
        }

        @Override
        public String getKey() {
            return this.currentKey;
        }

        @Override
        public V getValue() {
            return StringKeyedMapAdapter.this.get(this.currentKey);
        }

        @Override
        public V setValue(V value) {
            return StringKeyedMapAdapter.this.put(this.currentKey, value);
        }
    }

    private class EntryIterator
    extends AbstractKeyIterator
    implements Iterator<Map.Entry<String, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<String, V> next() {
            return new EntrySetEntry(this.nextKey());
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<String, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry entry = this.getAsEntry(o);
            if (entry == null || entry.getKey() == null || entry.getValue() == null) {
                return false;
            }
            Object valueFromThisMap = StringKeyedMapAdapter.this.get(entry.getKey());
            return entry.getValue().equals(valueFromThisMap);
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry entry = this.getAsEntry(o);
            if (entry == null || entry.getKey() == null || entry.getValue() == null) {
                return false;
            }
            Object valueFromThisMap = StringKeyedMapAdapter.this.get(entry.getKey());
            if (!entry.getValue().equals(valueFromThisMap)) {
                return false;
            }
            return StringKeyedMapAdapter.this.remove(entry.getKey()) != null;
        }

        private Map.Entry<String, V> getAsEntry(Object o) {
            if (o instanceof Map.Entry) {
                return (Map.Entry)o;
            }
            return null;
        }
    }

    private class ValuesIterator
    extends AbstractKeyIterator
    implements Iterator<V> {
        private ValuesIterator() {
        }

        @Override
        public V next() {
            return StringKeyedMapAdapter.this.get(this.nextKey());
        }
    }

    private class Values
    extends AbstractSet<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValuesIterator();
        }

        @Override
        public boolean contains(Object o) {
            return StringKeyedMapAdapter.this.containsValue(o);
        }

        @Override
        public boolean remove(Object o) {
            if (o == null) {
                return false;
            }
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (!o.equals(it.next())) continue;
                it.remove();
                return true;
            }
            return false;
        }
    }

    private class KeyIterator
    extends AbstractKeyIterator
    implements Iterator<String> {
        private KeyIterator() {
        }

        @Override
        public String next() {
            return this.nextKey();
        }
    }

    private abstract class AbstractKeyIterator {
        private final Iterator<String> it;
        private String currentKey;

        private AbstractKeyIterator() {
            this.it = StringKeyedMapAdapter.this.getAttributeNames();
        }

        public void remove() {
            if (this.currentKey == null) {
                throw new NoSuchElementException("You must call next() at least once");
            }
            StringKeyedMapAdapter.this.remove(this.currentKey);
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        protected String nextKey() {
            this.currentKey = this.it.next();
            return this.currentKey;
        }
    }

    private class KeySet
    extends AbstractSet<String> {
        private KeySet() {
        }

        @Override
        public Iterator<String> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean contains(Object o) {
            return StringKeyedMapAdapter.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return StringKeyedMapAdapter.this.remove(o) != null;
        }
    }

    private abstract class AbstractSet<T>
    extends java.util.AbstractSet<T> {
        private AbstractSet() {
        }

        @Override
        public boolean isEmpty() {
            return StringKeyedMapAdapter.this.isEmpty();
        }

        @Override
        public int size() {
            return StringKeyedMapAdapter.this.size();
        }

        @Override
        public void clear() {
            StringKeyedMapAdapter.this.clear();
        }
    }
}

