/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression;

import org.springframework.binding.expression.ParserContext;
import org.springframework.util.Assert;

public class ExpressionVariable {
    private String name;
    private String valueExpression;
    private ParserContext parserContext;

    public ExpressionVariable(String name, String valueExpression) {
        this.init(name, valueExpression, null);
    }

    public ExpressionVariable(String name, String valueExpression, ParserContext parserContext) {
        this.init(name, valueExpression, parserContext);
    }

    public String getName() {
        return this.name;
    }

    public String getValueExpression() {
        return this.valueExpression;
    }

    public ParserContext getParserContext() {
        return this.parserContext;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExpressionVariable)) {
            return false;
        }
        ExpressionVariable var = (ExpressionVariable)o;
        return this.name.equals(var.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "[Expression Variable '" + this.name + "']";
    }

    private void init(String name, String valueExpression, ParserContext parserContext) {
        Assert.hasText((String)name, (String)"The expression variable must be named");
        Assert.hasText((String)valueExpression, (String)"The expression variable's value expression is required");
        this.name = name;
        this.valueExpression = valueExpression;
        this.parserContext = parserContext;
    }
}

