/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.beanwrapper;

import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.service.DefaultConversionService;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ParserContext;
import org.springframework.binding.expression.ParserException;
import org.springframework.binding.expression.beanwrapper.BeanWrapperExpression;
import org.springframework.binding.expression.support.AbstractExpressionParser;

public class BeanWrapperExpressionParser
extends AbstractExpressionParser {
    private ConversionService conversionService;
    private boolean autoGrowNestedPaths = false;
    private int autoGrowCollectionLimit = Integer.MAX_VALUE;

    public BeanWrapperExpressionParser() {
        this.conversionService = new DefaultConversionService();
    }

    public BeanWrapperExpressionParser(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setAutoGrowNestedPaths(boolean autoGrowNestedPaths) {
        this.autoGrowNestedPaths = autoGrowNestedPaths;
    }

    public void setAutoGrowCollectionLimit(int autoGrowCollectionLimit) {
        this.autoGrowCollectionLimit = autoGrowCollectionLimit;
    }

    @Override
    protected Expression doParseExpression(String expressionString, ParserContext context) throws ParserException {
        BeanWrapperExpression expression = new BeanWrapperExpression(expressionString, this.conversionService);
        expression.setAutoGrowNestedPaths(this.autoGrowNestedPaths);
        expression.setAutoGrowCollectionLimit(this.autoGrowCollectionLimit);
        return expression;
    }
}

