/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.spel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.service.DefaultConversionService;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.ExpressionVariable;
import org.springframework.binding.expression.ParserContext;
import org.springframework.binding.expression.ParserException;
import org.springframework.binding.expression.spel.SpringELExpression;
import org.springframework.binding.expression.support.NullParserContext;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class SpringELExpressionParser
implements ExpressionParser {
    private final SpelExpressionParser expressionParser;
    private final ConversionService conversionService;
    private final List<PropertyAccessor> propertyAccessors = new ArrayList<PropertyAccessor>();

    public SpringELExpressionParser(SpelExpressionParser expressionParser) {
        this(expressionParser, new DefaultConversionService());
    }

    public SpringELExpressionParser(SpelExpressionParser expressionParser, ConversionService conversionService) {
        this.expressionParser = expressionParser;
        this.propertyAccessors.add((PropertyAccessor)new MapAccessor());
        this.conversionService = conversionService;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void addPropertyAccessor(PropertyAccessor propertyAccessor) {
        this.propertyAccessors.add(propertyAccessor);
    }

    @Override
    public Expression parseExpression(String expression, ParserContext context) throws ParserException {
        Assert.hasText((String)expression, (String)"The expression string to parse is required and must not be empty");
        context = context == null ? NullParserContext.INSTANCE : context;
        Map<String, Expression> expressionVars = this.parseSpelExpressionVariables(context.getExpressionVariables());
        org.springframework.expression.Expression spelExpression = this.parseSpelExpression(expression, context);
        Class<?> expectedResultType = context.getExpectedEvaluationResultType();
        org.springframework.core.convert.ConversionService cs = this.conversionService.getDelegateConversionService();
        return this.createSpringELExpression(expressionVars, spelExpression, expectedResultType, cs);
    }

    protected SpringELExpression createSpringELExpression(Map<String, Expression> expressionVars, org.springframework.expression.Expression spelExpression, Class<?> expectedResultType, org.springframework.core.convert.ConversionService conversionService) {
        return new SpringELExpression(spelExpression, expressionVars, expectedResultType, conversionService, this.propertyAccessors);
    }

    private org.springframework.expression.Expression parseSpelExpression(String expression, ParserContext context) {
        org.springframework.expression.ParserContext spelParserContext = this.getSpelParserContext(context);
        if (spelParserContext != null) {
            return this.expressionParser.parseExpression(expression, spelParserContext);
        }
        return this.expressionParser.parseExpression(expression);
    }

    private org.springframework.expression.ParserContext getSpelParserContext(ParserContext context) {
        return context.isTemplate() ? org.springframework.expression.ParserContext.TEMPLATE_EXPRESSION : null;
    }

    private Map<String, Expression> parseSpelExpressionVariables(ExpressionVariable[] expressionVars) {
        if (expressionVars == null || expressionVars.length == 0) {
            return null;
        }
        HashMap<String, Expression> result = new HashMap<String, Expression>(expressionVars.length);
        for (ExpressionVariable var : expressionVars) {
            result.put(var.getName(), this.parseExpression(var.getValueExpression(), var.getParserContext()));
        }
        return result;
    }
}

