/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.support;

import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.Expression;
import org.springframework.core.style.ToStringCreator;

public class CompositeStringExpression
implements Expression {
    private Expression[] expressions;

    public CompositeStringExpression(Expression ... expressions) {
        this.expressions = expressions;
    }

    @Override
    public Object getValue(Object context) throws EvaluationException {
        StringBuilder value = new StringBuilder(128);
        for (Expression expression : this.expressions) {
            value.append(expression.getValue(context));
        }
        return value.toString();
    }

    @Override
    public void setValue(Object context, Object value) throws EvaluationException {
        throw new UnsupportedOperationException("Cannot set a composite string expression value");
    }

    @Override
    public Class<?> getValueType(Object context) {
        return String.class;
    }

    @Override
    public String getExpressionString() {
        return null;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("expressions", (Object)this.expressions).toString();
    }
}

