/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.ClientTioConfig;
import org.tio.client.ReconnConf;
import org.tio.cluster.TioClusterConfig;
import org.tio.cluster.TioClusterVo;
import org.tio.core.ChannelContext;
import org.tio.core.ChannelContextFilter;
import org.tio.core.PacketSendMode;
import org.tio.core.TioConfig;
import org.tio.core.intf.Packet;
import org.tio.server.ServerTioConfig;
import org.tio.utils.convert.Converter;
import org.tio.utils.lock.MapWithLock;
import org.tio.utils.lock.ReadLockHandler;
import org.tio.utils.lock.SetWithLock;
import org.tio.utils.page.Page;
import org.tio.utils.page.PageUtils;

public class Tio {
    private static Logger log = LoggerFactory.getLogger(Tio.class);

    public static void bindBsId(ChannelContext channelContext, String bsId) {
        channelContext.tioConfig.bsIds.bind(channelContext, bsId);
    }

    public static void bindGroup(ChannelContext channelContext, String group) {
        channelContext.tioConfig.groups.bind(group, channelContext);
    }

    public static void bindGroup(TioConfig tioConfig, String userid, final String group) {
        SetWithLock<ChannelContext> setWithLock = Tio.getByUserid(tioConfig, userid);
        if (setWithLock != null) {
            setWithLock.handle((ReadLockHandler)new ReadLockHandler<Set<ChannelContext>>(){

                public void handler(Set<ChannelContext> set) {
                    for (ChannelContext channelContext : set) {
                        Tio.bindGroup(channelContext, group);
                    }
                }
            });
        }
    }

    public static void bindToken(ChannelContext channelContext, String token) {
        channelContext.tioConfig.tokens.bind(token, channelContext);
    }

    public static void bindUser(ChannelContext channelContext, String userid) {
        channelContext.tioConfig.users.bind(userid, channelContext);
    }

    public static Boolean bSend(ChannelContext channelContext, Packet packet) {
        if (channelContext == null) {
            return false;
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        return Tio.send(channelContext, packet, countDownLatch, PacketSendMode.SINGLE_BLOCK);
    }

    public static Boolean bSend(TioConfig tioConfig, String ip, int port, Packet packet) {
        return Tio.send(tioConfig, ip, port, packet, true);
    }

    public static Boolean bSendToAll(TioConfig tioConfig, Packet packet, ChannelContextFilter channelContextFilter) {
        return Tio.sendToAll(tioConfig, packet, channelContextFilter, true);
    }

    public static Boolean bSendToBsId(TioConfig tioConfig, String bsId, Packet packet) {
        return Tio.sendToBsId(tioConfig, bsId, packet, true);
    }

    public static Boolean bSendToGroup(TioConfig tioConfig, String group, Packet packet) {
        return Tio.bSendToGroup(tioConfig, group, packet, null);
    }

    public static Boolean bSendToGroup(TioConfig tioConfig, String group, Packet packet, ChannelContextFilter channelContextFilter) {
        return Tio.sendToGroup(tioConfig, group, packet, channelContextFilter, true);
    }

    public static Boolean bSendToId(TioConfig tioConfig, String channelContextId, Packet packet) {
        return Tio.sendToId(tioConfig, channelContextId, packet, true);
    }

    public static Boolean bSendToIp(TioConfig tioConfig, String ip, Packet packet) {
        return Tio.bSendToIp(tioConfig, ip, packet, null);
    }

    public static Boolean bSendToIp(TioConfig tioConfig, String ip, Packet packet, ChannelContextFilter channelContextFilter) {
        return Tio.sendToIp(tioConfig, ip, packet, channelContextFilter, true);
    }

    public static Boolean bSendToSet(TioConfig tioConfig, SetWithLock<ChannelContext> setWithLock, Packet packet, ChannelContextFilter channelContextFilter) {
        return Tio.sendToSet(tioConfig, setWithLock, packet, channelContextFilter, true);
    }

    public static Boolean bSendToToken(TioConfig tioConfig, String token, Packet packet) {
        return Tio.sendToToken(tioConfig, token, packet, true);
    }

    public static Boolean bSendToUser(TioConfig tioConfig, String userid, Packet packet) {
        return Tio.sendToUser(tioConfig, userid, packet, true);
    }

    public static void close(ChannelContext channelContext, String remark) {
        Tio.close(channelContext, null, remark);
    }

    public static void close(ChannelContext channelContext, String remark, ChannelContext.CloseCode closeCode) {
        Tio.close(channelContext, null, remark, closeCode);
    }

    public static void close(ChannelContext channelContext, Throwable throwable, String remark) {
        Tio.close(channelContext, throwable, remark, false);
    }

    public static void close(ChannelContext channelContext, Throwable throwable, String remark, ChannelContext.CloseCode closeCode) {
        Tio.close(channelContext, throwable, remark, false, closeCode);
    }

    public static void close(ChannelContext channelContext, Throwable throwable, String remark, boolean isNeedRemove) {
        Tio.close(channelContext, throwable, remark, isNeedRemove, true);
    }

    public static void close(ChannelContext channelContext, Throwable throwable, String remark, boolean isNeedRemove, ChannelContext.CloseCode closeCode) {
        Tio.close(channelContext, throwable, remark, isNeedRemove, true, closeCode);
    }

    public static void close(ChannelContext channelContext, Throwable throwable, String remark, boolean isNeedRemove, boolean needCloseLock) {
        Tio.close(channelContext, throwable, remark, isNeedRemove, needCloseLock, null);
    }

    public static void close(ChannelContext channelContext, Throwable throwable, String remark, boolean isNeedRemove, boolean needCloseLock, ChannelContext.CloseCode closeCode) {
        if (channelContext == null) {
            return;
        }
        if (channelContext.isWaitingClose) {
            log.debug("{} \u6b63\u5728\u7b49\u5f85\u88ab\u5173\u95ed", (Object)channelContext);
            return;
        }
        channelContext.decodeRunnable.setCanceled(true);
        channelContext.handlerRunnable.setCanceled(true);
        channelContext.sendRunnable.setCanceled(true);
        ReentrantReadWriteLock.WriteLock writeLock = null;
        if (needCloseLock) {
            writeLock = channelContext.closeLock.writeLock();
            boolean tryLock = writeLock.tryLock();
            if (!tryLock) {
                return;
            }
            channelContext.isWaitingClose = true;
            writeLock.unlock();
        } else {
            channelContext.isWaitingClose = true;
        }
        if (closeCode == null) {
            if (channelContext.getCloseCode() == ChannelContext.CloseCode.INIT_STATUS) {
                channelContext.setCloseCode(ChannelContext.CloseCode.NO_CODE);
            }
        } else {
            channelContext.setCloseCode(closeCode);
        }
        if (channelContext.asynchronousSocketChannel != null) {
            try {
                channelContext.asynchronousSocketChannel.shutdownInput();
            }
            catch (Throwable tryLock) {
                // empty catch block
            }
            try {
                channelContext.asynchronousSocketChannel.shutdownOutput();
            }
            catch (Throwable tryLock) {
                // empty catch block
            }
            try {
                channelContext.asynchronousSocketChannel.close();
            }
            catch (Throwable tryLock) {
                // empty catch block
            }
        }
        channelContext.closeMeta.setRemark(remark);
        channelContext.closeMeta.setThrowable(throwable);
        if (!isNeedRemove) {
            if (channelContext.isServer()) {
                isNeedRemove = true;
            } else {
                ClientChannelContext clientChannelContext = (ClientChannelContext)channelContext;
                if (!ReconnConf.isNeedReconn(clientChannelContext, false)) {
                    isNeedRemove = true;
                }
            }
        }
        channelContext.closeMeta.setNeedRemove(isNeedRemove);
        channelContext.tioConfig.closeRunnable.addMsg((Object)channelContext);
        channelContext.tioConfig.closeRunnable.execute();
    }

    public static void close(TioConfig tioConfig, String clientIp, Integer clientPort, Throwable throwable, String remark) {
        ChannelContext channelContext = tioConfig.clientNodes.find(clientIp, clientPort);
        Tio.close(channelContext, throwable, remark);
    }

    public static void closeIp(TioConfig tioConfig, String ip, String remark) {
        Tio.closeIp(tioConfig, ip, remark, null);
    }

    public static void closeIp(TioConfig tioConfig, String ip, String remark, ChannelContext.CloseCode closeCode) {
        SetWithLock<ChannelContext> setWithLock = Tio.getByIp(tioConfig, ip);
        Tio.closeSet(tioConfig, setWithLock, remark, closeCode);
    }

    public static void closeGroup(TioConfig tioConfig, String group, String remark) {
        Tio.closeGroup(tioConfig, group, remark, null);
    }

    public static void closeGroup(TioConfig tioConfig, String group, String remark, ChannelContext.CloseCode closeCode) {
        SetWithLock<ChannelContext> setWithLock = Tio.getByGroup(tioConfig, group);
        Tio.closeSet(tioConfig, setWithLock, remark, closeCode);
    }

    public static void closeUser(TioConfig tioConfig, String userid, String remark) {
        Tio.closeUser(tioConfig, userid, remark, null);
    }

    public static void closeUser(TioConfig tioConfig, String userid, String remark, ChannelContext.CloseCode closeCode) {
        SetWithLock<ChannelContext> setWithLock = Tio.getByUserid(tioConfig, userid);
        Tio.closeSet(tioConfig, setWithLock, remark, closeCode);
    }

    public static void closeToken(TioConfig tioConfig, String token, String remark) {
        Tio.closeToken(tioConfig, token, remark, null);
    }

    public static void closeToken(TioConfig tioConfig, String token, String remark, ChannelContext.CloseCode closeCode) {
        SetWithLock<ChannelContext> setWithLock = Tio.getByToken(tioConfig, token);
        Tio.closeSet(tioConfig, setWithLock, remark, closeCode);
    }

    public static void removeIp(TioConfig tioConfig, String ip, String remark) {
        Tio.removeIp(tioConfig, ip, remark, null);
    }

    public static void removeIp(TioConfig tioConfig, String ip, String remark, ChannelContext.CloseCode removeCode) {
        SetWithLock<ChannelContext> setWithLock = Tio.getByIp(tioConfig, ip);
        Tio.removeSet(tioConfig, setWithLock, remark, removeCode);
    }

    public static void removeGroup(TioConfig tioConfig, String group, String remark) {
        Tio.removeGroup(tioConfig, group, remark, null);
    }

    public static void removeGroup(TioConfig tioConfig, String group, String remark, ChannelContext.CloseCode removeCode) {
        SetWithLock<ChannelContext> setWithLock = Tio.getByGroup(tioConfig, group);
        Tio.removeSet(tioConfig, setWithLock, remark, removeCode);
    }

    public static void removeUser(TioConfig tioConfig, String userid, String remark) {
        Tio.removeUser(tioConfig, userid, remark, null);
    }

    public static void removeUser(TioConfig tioConfig, String userid, String remark, ChannelContext.CloseCode removeCode) {
        SetWithLock<ChannelContext> setWithLock = Tio.getByUserid(tioConfig, userid);
        Tio.removeSet(tioConfig, setWithLock, remark, removeCode);
    }

    public static void removeToken(TioConfig tioConfig, String token, String remark) {
        Tio.removeToken(tioConfig, token, remark, null);
    }

    public static void removeToken(TioConfig tioConfig, String token, String remark, ChannelContext.CloseCode removeCode) {
        SetWithLock<ChannelContext> setWithLock = Tio.getByToken(tioConfig, token);
        Tio.removeSet(tioConfig, setWithLock, remark, removeCode);
    }

    public static void closeSet(TioConfig tioConfig, SetWithLock<ChannelContext> setWithLock, final String remark, final ChannelContext.CloseCode closeCode) {
        if (setWithLock != null) {
            setWithLock.handle((ReadLockHandler)new ReadLockHandler<Set<ChannelContext>>(){

                public void handler(Set<ChannelContext> set) {
                    for (ChannelContext channelContext : set) {
                        Tio.close(channelContext, remark, closeCode);
                    }
                }
            });
        }
    }

    public static void removeSet(TioConfig tioConfig, SetWithLock<ChannelContext> setWithLock, final String remark, final ChannelContext.CloseCode closeCode) {
        if (setWithLock != null) {
            setWithLock.handle((ReadLockHandler)new ReadLockHandler<Set<ChannelContext>>(){

                public void handler(Set<ChannelContext> set) {
                    for (ChannelContext channelContext : set) {
                        Tio.remove(channelContext, remark, closeCode);
                    }
                }
            });
        }
    }

    public static SetWithLock<ChannelContext> getAll(TioConfig tioConfig) {
        return tioConfig.connections;
    }

    public static SetWithLock<ChannelContext> getAllChannelContexts(TioConfig tioConfig) {
        return Tio.getAll(tioConfig);
    }

    public static SetWithLock<ChannelContext> getConnecteds(ClientTioConfig clientTioConfig) {
        return clientTioConfig.connecteds;
    }

    public static SetWithLock<ChannelContext> getAllConnectedsChannelContexts(ClientTioConfig clientTioConfig) {
        return Tio.getConnecteds(clientTioConfig);
    }

    public static ChannelContext getByBsId(TioConfig tioConfig, String bsId) {
        return tioConfig.bsIds.find(tioConfig, bsId);
    }

    public static ChannelContext getChannelContextByBsId(TioConfig tioConfig, String bsId) {
        return Tio.getByBsId(tioConfig, bsId);
    }

    public static ChannelContext getByClientNode(TioConfig tioConfig, String clientIp, Integer clientPort) {
        return tioConfig.clientNodes.find(clientIp, clientPort);
    }

    public static ChannelContext getChannelContextByClientNode(TioConfig tioConfig, String clientIp, Integer clientPort) {
        return Tio.getByClientNode(tioConfig, clientIp, clientPort);
    }

    public static ChannelContext getByChannelContextId(TioConfig tioConfig, String channelContextId) {
        return tioConfig.ids.find(tioConfig, channelContextId);
    }

    public static ChannelContext getChannelContextById(TioConfig tioConfig, String channelContextId) {
        return Tio.getByChannelContextId(tioConfig, channelContextId);
    }

    public static SetWithLock<ChannelContext> getByGroup(TioConfig tioConfig, String group) {
        return tioConfig.groups.clients(tioConfig, group);
    }

    public static SetWithLock<ChannelContext> getChannelContextsByGroup(TioConfig tioConfig, String group) {
        return Tio.getByGroup(tioConfig, group);
    }

    public static SetWithLock<ChannelContext> getByToken(TioConfig tioConfig, String token) {
        return tioConfig.tokens.find(tioConfig, token);
    }

    public static SetWithLock<ChannelContext> getByIp(TioConfig tioConfig, String ip) {
        return tioConfig.ips.clients(tioConfig, ip);
    }

    public static SetWithLock<ChannelContext> getChannelContextsByToken(TioConfig tioConfig, String token) {
        return Tio.getByToken(tioConfig, token);
    }

    public static SetWithLock<ChannelContext> getByUserid(TioConfig tioConfig, String userid) {
        return tioConfig.users.find(tioConfig, userid);
    }

    public static SetWithLock<ChannelContext> getChannelContextsByUserid(TioConfig tioConfig, String userid) {
        return Tio.getByUserid(tioConfig, userid);
    }

    public static Page<ChannelContext> getPageOfAll(TioConfig tioConfig, Integer pageIndex, Integer pageSize) {
        return Tio.getPageOfAll(tioConfig, pageIndex, pageSize, null);
    }

    public static <T> Page<T> getPageOfAll(TioConfig tioConfig, Integer pageIndex, Integer pageSize, Converter<T> converter) {
        SetWithLock<ChannelContext> setWithLock = Tio.getAllChannelContexts(tioConfig);
        return PageUtils.fromSetWithLock(setWithLock, (int)pageIndex, (int)pageSize, converter);
    }

    public static Page<ChannelContext> getPageOfConnecteds(ClientTioConfig clientTioConfig, Integer pageIndex, Integer pageSize) {
        return Tio.getPageOfConnecteds(clientTioConfig, pageIndex, pageSize, null);
    }

    public static <T> Page<T> getPageOfConnecteds(ClientTioConfig clientTioConfig, Integer pageIndex, Integer pageSize, Converter<T> converter) {
        SetWithLock<ChannelContext> setWithLock = Tio.getAllConnectedsChannelContexts(clientTioConfig);
        return PageUtils.fromSetWithLock(setWithLock, (int)pageIndex, (int)pageSize, converter);
    }

    public static Page<ChannelContext> getPageOfGroup(TioConfig tioConfig, String group, Integer pageIndex, Integer pageSize) {
        return Tio.getPageOfGroup(tioConfig, group, pageIndex, pageSize, null);
    }

    public static <T> Page<T> getPageOfGroup(TioConfig tioConfig, String group, Integer pageIndex, Integer pageSize, Converter<T> converter) {
        SetWithLock<ChannelContext> setWithLock = Tio.getChannelContextsByGroup(tioConfig, group);
        return PageUtils.fromSetWithLock(setWithLock, (int)pageIndex, (int)pageSize, converter);
    }

    public static int groupCount(TioConfig tioConfig, String group) {
        SetWithLock<ChannelContext> setWithLock = tioConfig.groups.clients(tioConfig, group);
        if (setWithLock == null) {
            return 0;
        }
        Set set = (Set)setWithLock.getObj();
        if (set == null) {
            return 0;
        }
        return set.size();
    }

    public static boolean isInGroup(String group, ChannelContext channelContext) {
        SetWithLock<String> setWithLock = channelContext.getGroups();
        if (setWithLock == null) {
            return false;
        }
        Set set = (Set)setWithLock.getObj();
        if (set == null) {
            return false;
        }
        return set.contains(group);
    }

    public static void notifyClusterForBsId(TioConfig tioConfig, String bsId, Packet packet) {
        TioClusterConfig tioClusterConfig = tioConfig.getTioClusterConfig();
        TioClusterVo tioClusterVo = new TioClusterVo(packet);
        tioClusterVo.setBsId(bsId);
        tioClusterConfig.publish(tioClusterVo);
    }

    public static void notifyClusterForGroup(TioConfig tioConfig, String group, Packet packet) {
        TioClusterConfig tioClusterConfig = tioConfig.getTioClusterConfig();
        TioClusterVo tioClusterVo = new TioClusterVo(packet);
        tioClusterVo.setGroup(group);
        tioClusterConfig.publish(tioClusterVo);
    }

    public static void notifyClusterForId(TioConfig tioConfig, String channelContextId, Packet packet) {
        TioClusterConfig tioClusterConfig = tioConfig.getTioClusterConfig();
        TioClusterVo tioClusterVo = new TioClusterVo(packet);
        tioClusterVo.setChannelId(channelContextId);
        tioClusterConfig.publish(tioClusterVo);
    }

    public static void notifyClusterForIp(TioConfig tioConfig, String ip, Packet packet) {
        TioClusterConfig tioClusterConfig = tioConfig.getTioClusterConfig();
        TioClusterVo tioClusterVo = new TioClusterVo(packet);
        tioClusterVo.setIp(ip);
        tioClusterConfig.publish(tioClusterVo);
    }

    public static void notifyClusterForToken(TioConfig tioConfig, String token, Packet packet) {
        TioClusterConfig tioClusterConfig = tioConfig.getTioClusterConfig();
        TioClusterVo tioClusterVo = new TioClusterVo(packet);
        tioClusterVo.setToken(token);
        tioClusterConfig.publish(tioClusterVo);
    }

    public static void notifyClusterForUser(TioConfig tioConfig, String userid, Packet packet) {
        TioClusterConfig tioClusterConfig = tioConfig.getTioClusterConfig();
        TioClusterVo tioClusterVo = new TioClusterVo(packet);
        tioClusterVo.setUserid(userid);
        tioClusterConfig.publish(tioClusterVo);
    }

    public static void remove(ChannelContext channelContext, String remark) {
        Tio.remove(channelContext, remark, null);
    }

    public static void remove(ChannelContext channelContext, String remark, ChannelContext.CloseCode closeCode) {
        Tio.remove(channelContext, null, remark, closeCode);
    }

    public static void remove(ChannelContext channelContext, Throwable throwable, String remark) {
        Tio.remove(channelContext, throwable, remark, (ChannelContext.CloseCode)null);
    }

    public static void remove(ChannelContext channelContext, Throwable throwable, String remark, ChannelContext.CloseCode closeCode) {
        Tio.close(channelContext, throwable, remark, true, closeCode);
    }

    public static void remove(TioConfig tioConfig, String clientIp, Integer clientPort, Throwable throwable, String remark) {
        Tio.remove(tioConfig, clientIp, clientPort, throwable, remark, null);
    }

    public static void remove(TioConfig tioConfig, String clientIp, Integer clientPort, Throwable throwable, String remark, ChannelContext.CloseCode closeCode) {
        ChannelContext channelContext = tioConfig.clientNodes.find(clientIp, clientPort);
        Tio.remove(channelContext, throwable, remark, closeCode);
    }

    public static void remove(ServerTioConfig serverTioConfig, String ip, String remark) {
        Tio.remove(serverTioConfig, ip, remark, (ChannelContext.CloseCode)null);
    }

    public static void remove(ServerTioConfig serverTioConfig, String ip, final String remark, final ChannelContext.CloseCode closeCode) {
        SetWithLock<ChannelContext> setWithLock = serverTioConfig.ips.clients(serverTioConfig, ip);
        if (setWithLock == null) {
            return;
        }
        setWithLock.handle((ReadLockHandler)new ReadLockHandler<Set<ChannelContext>>(){

            public void handler(Set<ChannelContext> set) {
                for (ChannelContext channelContext : set) {
                    Tio.remove(channelContext, remark, closeCode);
                }
            }
        });
    }

    public static Boolean send(ChannelContext channelContext, Packet packet) {
        return Tio.send(channelContext, packet, null, null);
    }

    private static Boolean send(ChannelContext channelContext, Packet packet, CountDownLatch countDownLatch, PacketSendMode packetSendMode) {
        try {
            if (packet == null || channelContext == null) {
                if (countDownLatch != null) {
                    countDownLatch.countDown();
                }
                return false;
            }
            if (channelContext.isVirtual) {
                if (countDownLatch != null) {
                    countDownLatch.countDown();
                }
                return true;
            }
            if (channelContext.isClosed || channelContext.isRemoved) {
                if (countDownLatch != null) {
                    countDownLatch.countDown();
                }
                if (channelContext != null) {
                    log.info("can't send data, {}, isClosed:{}, isRemoved:{}", new Object[]{channelContext, channelContext.isClosed, channelContext.isRemoved});
                }
                return false;
            }
            if (channelContext.tioConfig.packetConverter != null) {
                Packet packet1 = channelContext.tioConfig.packetConverter.convert(packet, channelContext);
                if (packet1 == null) {
                    if (log.isInfoEnabled()) {
                        log.info("convert\u540e\u4e3anull\uff0c\u8868\u793a\u4e0d\u9700\u8981\u53d1\u9001", (Object)channelContext, (Object)packet.logstr());
                    }
                    return true;
                }
                packet = packet1;
            }
            boolean isSingleBlock = countDownLatch != null && packetSendMode == PacketSendMode.SINGLE_BLOCK;
            boolean isAdded = false;
            if (countDownLatch != null) {
                Packet.Meta meta = new Packet.Meta();
                meta.setCountDownLatch(countDownLatch);
                packet.setMeta(meta);
            }
            if (!(isAdded = channelContext.tioConfig.useQueueSend ? channelContext.sendRunnable.addMsg(packet) : channelContext.sendRunnable.sendPacket(packet))) {
                if (countDownLatch != null) {
                    countDownLatch.countDown();
                }
                return false;
            }
            if (channelContext.tioConfig.useQueueSend) {
                channelContext.sendRunnable.execute();
            }
            if (isSingleBlock) {
                long timeout = 10L;
                try {
                    Boolean awaitFlag = countDownLatch.await(timeout, TimeUnit.SECONDS);
                    if (!awaitFlag.booleanValue()) {
                        log.error("{}, \u963b\u585e\u53d1\u9001\u8d85\u65f6, timeout:{}s, packet:{}", new Object[]{channelContext, timeout, packet.logstr()});
                    }
                }
                catch (InterruptedException e) {
                    log.error(e.toString(), (Throwable)e);
                }
                Boolean isSentSuccess = packet.getMeta().getIsSentSuccess();
                return isSentSuccess;
            }
            return true;
        }
        catch (Throwable e) {
            log.error((Object)((Object)channelContext) + ", " + e.toString(), e);
            return false;
        }
    }

    public static Boolean send(TioConfig tioConfig, String ip, int port, Packet packet) {
        return Tio.send(tioConfig, ip, port, packet, false);
    }

    private static Boolean send(TioConfig tioConfig, String ip, int port, Packet packet, boolean isBlock) {
        ChannelContext channelContext = tioConfig.clientNodes.find(ip, port);
        if (channelContext != null) {
            if (isBlock) {
                return Tio.bSend(channelContext, packet);
            }
            return Tio.send(channelContext, packet);
        }
        log.info("{}, can find channelContext by {}:{}", new Object[]{tioConfig.getName(), ip, port});
        return false;
    }

    public static void sendToAll(TioConfig tioConfig, Packet packet) {
        Tio.sendToAll(tioConfig, packet, null);
    }

    public static void sendToAll(TioConfig tioConfig, Packet packet, ChannelContextFilter channelContextFilter) {
        Tio.sendToAll(tioConfig, packet, channelContextFilter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Boolean sendToAll(TioConfig tioConfig, Packet packet, ChannelContextFilter channelContextFilter, boolean isBlock) {
        try {
            Boolean ret;
            SetWithLock<ChannelContext> setWithLock = tioConfig.connections;
            if (setWithLock == null) {
                log.debug("{}, \u6ca1\u6709\u4efb\u4f55\u8fde\u63a5", (Object)tioConfig.getName());
                Boolean bl = false;
                return bl;
            }
            Boolean bl = ret = Tio.sendToSet(tioConfig, setWithLock, packet, channelContextFilter, isBlock);
            return bl;
        }
        finally {
            TioClusterConfig tioClusterConfig;
            if (tioConfig.isCluster() && !packet.isFromCluster() && (tioClusterConfig = tioConfig.getTioClusterConfig()).isCluster4all()) {
                TioClusterVo tioClusterVo = new TioClusterVo(packet);
                tioClusterVo.setToAll(true);
                tioClusterConfig.publish(tioClusterVo);
            }
        }
    }

    public static Boolean sendToBsId(TioConfig tioConfig, String bsId, Packet packet) {
        return Tio.sendToBsId(tioConfig, bsId, packet, false);
    }

    private static Boolean sendToBsId(TioConfig tioConfig, String bsId, Packet packet, boolean isBlock) {
        ChannelContext channelContext = Tio.getChannelContextByBsId(tioConfig, bsId);
        if (channelContext == null) {
            TioClusterConfig tioClusterConfig;
            if (tioConfig.isCluster() && !packet.isFromCluster() && (tioClusterConfig = tioConfig.getTioClusterConfig()).isCluster4bsId()) {
                Tio.notifyClusterForBsId(tioConfig, bsId, packet);
            }
            return false;
        }
        if (isBlock) {
            return Tio.bSend(channelContext, packet);
        }
        return Tio.send(channelContext, packet);
    }

    public static void sendToGroup(TioConfig tioConfig, String group, Packet packet) {
        Tio.sendToGroup(tioConfig, group, packet, null);
    }

    public static void sendToGroup(TioConfig tioConfig, String group, Packet packet, ChannelContextFilter channelContextFilter) {
        Tio.sendToGroup(tioConfig, group, packet, channelContextFilter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Boolean sendToGroup(TioConfig tioConfig, String group, Packet packet, ChannelContextFilter channelContextFilter, boolean isBlock) {
        try {
            Boolean ret;
            SetWithLock<ChannelContext> setWithLock = tioConfig.groups.clients(tioConfig, group);
            if (setWithLock == null) {
                log.debug("{}, \u7ec4[{}]\u4e0d\u5b58\u5728", (Object)tioConfig.getName(), (Object)group);
                Boolean bl = false;
                return bl;
            }
            Boolean bl = ret = Tio.sendToSet(tioConfig, setWithLock, packet, channelContextFilter, isBlock);
            return bl;
        }
        finally {
            TioClusterConfig tioClusterConfig;
            if (tioConfig.isCluster() && !packet.isFromCluster() && (tioClusterConfig = tioConfig.getTioClusterConfig()).isCluster4group()) {
                Tio.notifyClusterForGroup(tioConfig, group, packet);
            }
        }
    }

    public static Boolean sendToId(TioConfig tioConfig, String channelContextId, Packet packet) {
        return Tio.sendToId(tioConfig, channelContextId, packet, false);
    }

    private static Boolean sendToId(TioConfig tioConfig, String channelContextId, Packet packet, boolean isBlock) {
        ChannelContext channelContext = Tio.getChannelContextById(tioConfig, channelContextId);
        if (channelContext == null) {
            TioClusterConfig tioClusterConfig;
            if (tioConfig.isCluster() && !packet.isFromCluster() && (tioClusterConfig = tioConfig.getTioClusterConfig()).isCluster4channelId()) {
                Tio.notifyClusterForId(tioConfig, channelContextId, packet);
            }
            return false;
        }
        if (isBlock) {
            return Tio.bSend(channelContext, packet);
        }
        return Tio.send(channelContext, packet);
    }

    public static void sendToIp(TioConfig tioConfig, String ip, Packet packet) {
        Tio.sendToIp(tioConfig, ip, packet, null);
    }

    public static void sendToIp(TioConfig tioConfig, String ip, Packet packet, ChannelContextFilter channelContextFilter) {
        Tio.sendToIp(tioConfig, ip, packet, channelContextFilter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Boolean sendToIp(TioConfig tioConfig, String ip, Packet packet, ChannelContextFilter channelContextFilter, boolean isBlock) {
        try {
            Boolean ret;
            SetWithLock<ChannelContext> setWithLock = tioConfig.ips.clients(tioConfig, ip);
            if (setWithLock == null) {
                log.info("{}, \u6ca1\u6709ip\u4e3a[{}]\u7684\u5bf9\u7aef", (Object)tioConfig.getName(), (Object)ip);
                Boolean bl = false;
                return bl;
            }
            Boolean bl = ret = Tio.sendToSet(tioConfig, setWithLock, packet, channelContextFilter, isBlock);
            return bl;
        }
        finally {
            TioClusterConfig tioClusterConfig;
            if (tioConfig.isCluster() && !packet.isFromCluster() && (tioClusterConfig = tioConfig.getTioClusterConfig()).isCluster4ip()) {
                Tio.notifyClusterForIp(tioConfig, ip, packet);
            }
        }
    }

    public static void sendToSet(TioConfig tioConfig, SetWithLock<ChannelContext> setWithLock, Packet packet, ChannelContextFilter channelContextFilter) {
        Tio.sendToSet(tioConfig, setWithLock, packet, channelContextFilter, false);
    }

    /*
     * Exception decompiling
     */
    private static Boolean sendToSet(TioConfig tioConfig, SetWithLock<ChannelContext> setWithLock, Packet packet, ChannelContextFilter channelContextFilter, boolean isBlock) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK], 9[CATCHBLOCK], 2[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Boolean sendToToken(TioConfig tioConfig, String token, Packet packet) {
        return Tio.sendToToken(tioConfig, token, packet, false);
    }

    /*
     * Exception decompiling
     */
    private static Boolean sendToToken(TioConfig tioConfig, String token, Packet packet, boolean isBlock) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Boolean sendToUser(TioConfig tioConfig, String userid, Packet packet) {
        return Tio.sendToUser(tioConfig, userid, packet, false);
    }

    /*
     * Exception decompiling
     */
    private static Boolean sendToUser(TioConfig tioConfig, String userid, Packet packet, boolean isBlock) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Packet synSend(ChannelContext channelContext, Packet packet, long timeout) {
        Integer synSeq = packet.getSynSeq();
        if (synSeq == null || synSeq <= 0) {
            throw new RuntimeException("synSeq\u5fc5\u987b\u5927\u4e8e0");
        }
        MapWithLock<Integer, Packet> waitingResps = channelContext.tioConfig.getWaitingResps();
        try {
            waitingResps.put((Object)synSeq, (Object)packet);
            Packet packet2 = packet;
            synchronized (packet2) {
                Tio.send(channelContext, packet);
                try {
                    packet.wait(timeout);
                }
                catch (InterruptedException e) {
                    log.error(e.toString(), (Throwable)e);
                }
            }
        }
        catch (Throwable e) {
            log.error(e.toString(), e);
        }
        finally {
            Packet respPacket = (Packet)waitingResps.remove((Object)synSeq);
            if (respPacket == null) {
                log.error("respPacket == null,{}", (Object)channelContext);
                return null;
            }
            if (respPacket == packet) {
                log.error("{}, \u540c\u6b65\u53d1\u9001\u8d85\u65f6, {}", (Object)channelContext.tioConfig.getName(), (Object)channelContext);
                return null;
            }
            return respPacket;
        }
    }

    public static void unbindBsId(ChannelContext channelContext) {
        channelContext.tioConfig.bsIds.unbind(channelContext);
    }

    public static void unbindGroup(ChannelContext channelContext) {
        channelContext.tioConfig.groups.unbind(channelContext);
    }

    public static void unbindGroup(String group, ChannelContext channelContext) {
        channelContext.tioConfig.groups.unbind(group, channelContext);
    }

    public static void unbindGroup(TioConfig tioConfig, String userid, final String group) {
        SetWithLock<ChannelContext> setWithLock = Tio.getByUserid(tioConfig, userid);
        if (setWithLock != null) {
            setWithLock.handle((ReadLockHandler)new ReadLockHandler<Set<ChannelContext>>(){

                public void handler(Set<ChannelContext> set) {
                    for (ChannelContext channelContext : set) {
                        Tio.unbindGroup(group, channelContext);
                    }
                }
            });
        }
    }

    public static void unbindToken(ChannelContext channelContext) {
        channelContext.tioConfig.tokens.unbind(channelContext);
    }

    public static void unbindToken(TioConfig tioConfig, String token) {
        tioConfig.tokens.unbind(tioConfig, token);
    }

    public static void unbindUser(ChannelContext channelContext) {
        channelContext.tioConfig.users.unbind(channelContext);
    }

    public static void unbindUser(TioConfig tioConfig, String userid) {
        tioConfig.users.unbind(tioConfig, userid);
    }

    private Tio() {
    }

    public static class IpBlacklist {
        public static boolean add(TioConfig tioConfig, String ip) {
            return tioConfig.ipBlacklist.add(ip);
        }

        public static boolean add(String ip) {
            return org.tio.core.maintain.IpBlacklist.GLOBAL.add(ip);
        }

        public static void clear(TioConfig tioConfig) {
            tioConfig.ipBlacklist.clear();
        }

        public static void clear() {
            org.tio.core.maintain.IpBlacklist.GLOBAL.clear();
        }

        public static Collection<String> getAll(TioConfig tioConfig) {
            return tioConfig.ipBlacklist.getAll();
        }

        public static Collection<String> getAll() {
            return org.tio.core.maintain.IpBlacklist.GLOBAL.getAll();
        }

        public static boolean isInBlacklist(TioConfig tioConfig, String ip) {
            return tioConfig.ipBlacklist.isInBlacklist(ip) || org.tio.core.maintain.IpBlacklist.GLOBAL.isInBlacklist(ip);
        }

        public static void remove(TioConfig tioConfig, String ip) {
            tioConfig.ipBlacklist.remove(ip);
        }

        public static void remove(String ip) {
            org.tio.core.maintain.IpBlacklist.GLOBAL.remove(ip);
        }
    }
}

