/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResource;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.handler.HttpRequestHandler;
import org.tio.http.common.session.HttpSession;
import org.tio.http.common.session.id.ISessionIdGenerator;
import org.tio.http.common.session.limiter.SessionRateLimiter;
import org.tio.http.common.view.freemarker.FreemarkerConfig;
import org.tio.utils.cache.ICache;
import org.tio.utils.hutool.FileUtil;
import org.tio.utils.hutool.StrUtil;

public class HttpConfig {
    private static Logger log = LoggerFactory.getLogger(HttpConfig.class);
    public static final String TIO_HTTP_SESSIONID = "tio_http_sessionid";
    public static final String SESSION_CACHE_NAME = "tio-h-s";
    public static final String SESSION_COOKIE_NAME = "PHPSESSID";
    public static final long DEFAULT_SESSION_TIMEOUT = 1800L;
    public static final int MAX_LIVETIME_OF_STATICRES = 600;
    public static final int MAX_LENGTH_OF_BOUNDARY = 512;
    public static final int MAX_LENGTH_OF_MULTI_HEADER = 512;
    public static final int MAX_LENGTH_OF_MULTI_BODY = 0x200000;
    private int maxLengthOfMultiBody = 0x200000;
    public static final int MAX_LENGTH_OF_POST_BODY = 0x200000;
    public static final String JSONP_PARAM_NAME = "tio_http_jsonp";
    private int maxLengthOfPostBody = 0x200000;
    public static final int MAX_FORWARD_COUNT = 10;
    public int maxForwardCount = 10;
    private boolean useSession = true;
    public boolean compatible1_0 = true;
    private boolean appendRequestHeaderString = false;
    private String bindIp = null;
    private Integer bindPort = 80;
    private String serverInfo = "t-io";
    private String charset = "utf-8";
    private ICache sessionStore = null;
    public SessionRateLimiter sessionRateLimiter;
    private String contextPath = "";
    private String suffix = "";
    private String welcomeFile = null;
    private String[] allowDomains = null;
    private String sessionCacheName = "tio-h-s";
    private long sessionTimeout = 1800L;
    private String sessionCookieName = "PHPSESSID";
    private int maxLiveTimeOfStaticRes = 600;
    private String page404 = "/404.html";
    private String page500 = "/500.html";
    private ISessionIdGenerator sessionIdGenerator;
    private HttpRequestHandler httpRequestHandler;
    private HttpResponse respForBlackIp = null;
    private boolean isProxied = false;
    private String pageRoot = null;
    private boolean pageInClasspath = false;
    private FreemarkerConfig freemarkerConfig = null;
    private volatile Map<String, String> domainPageMap = null;
    public boolean checkHost = true;
    private String name = null;
    private String jsonpParamName = "tio_http_jsonp";
    public boolean monitorFileChange = false;
    private Map<String, Set<String>> staticPathsMap = null;
    private Set<String> staticPaths = null;

    public Map<String, String> getDomainPageMap() {
        return this.domainPageMap;
    }

    public HttpConfig(Integer bindPort, boolean useSession) {
        this.bindPort = bindPort;
        this.useSession = useSession;
    }

    public HttpConfig(Integer bindPort, Long sessionTimeout, String contextPath, String suffix) {
        this.bindPort = bindPort;
        if (sessionTimeout != null) {
            this.sessionTimeout = sessionTimeout;
        }
        if (contextPath == null) {
            contextPath = "";
        }
        this.contextPath = contextPath;
        if (suffix == null) {
            suffix = "";
        }
        this.suffix = suffix;
    }

    public String getBindIp() {
        return this.bindIp;
    }

    public Integer getBindPort() {
        return this.bindPort;
    }

    public String getCharset() {
        return this.charset;
    }

    public int getMaxLiveTimeOfStaticRes() {
        return this.maxLiveTimeOfStaticRes;
    }

    public String getPage404() {
        return this.page404;
    }

    public String getPage500() {
        return this.page500;
    }

    public String getPageRoot() {
        return this.pageRoot;
    }

    public String getPageRoot(HttpRequest request) {
        if (this.domainPageMap == null || this.domainPageMap.isEmpty()) {
            return this.pageRoot;
        }
        String domain = request.getDomain();
        String root = this.domainPageMap.get(domain);
        if (root != null) {
            return root;
        }
        Set<Map.Entry<String, String>> set = this.domainPageMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String d = entry.getKey();
            if (!d.startsWith(".") || !domain.endsWith(d)) continue;
            String file = entry.getValue();
            this.domainPageMap.put(domain, file);
            return file;
        }
        this.domainPageMap.put(domain, this.pageRoot);
        return this.pageRoot;
    }

    public HttpResource getResource(HttpRequest request, String path) throws Exception {
        String pageRoot = this.getPageRoot(request);
        HttpResource httpResource = null;
        if (pageRoot != null) {
            if (StrUtil.endWith((CharSequence)path, (CharSequence)"/")) {
                path = (String)path + "index.html";
            }
            String complatePath = pageRoot + (String)path;
            if (this.pageInClasspath) {
                URL url = this.getClass().getClassLoader().getResource(complatePath);
                if (url != null) {
                    String protocol = url.getProtocol();
                    if (Objects.equals(protocol, "jar")) {
                        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(complatePath);
                        httpResource = new HttpResource((String)path, inputStream, null);
                    } else {
                        File file = new File(url.toURI());
                        if (file.exists()) {
                            httpResource = new HttpResource((String)path, null, file);
                        }
                    }
                }
            } else {
                File file = new File(complatePath);
                if (file.exists()) {
                    httpResource = new HttpResource((String)path, null, file);
                }
            }
        }
        return httpResource;
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public String getSessionCacheName() {
        return this.sessionCacheName;
    }

    public String getSessionCookieName() {
        return this.sessionCookieName;
    }

    public ISessionIdGenerator getSessionIdGenerator() {
        return this.sessionIdGenerator;
    }

    public ICache getSessionStore() {
        return this.sessionStore;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setBindIp(String bindIp) {
        this.bindIp = bindIp;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setMaxLiveTimeOfStaticRes(int maxLiveTimeOfStaticRes) {
        this.maxLiveTimeOfStaticRes = maxLiveTimeOfStaticRes;
    }

    public void setPage404(String page404) {
        this.page404 = page404;
    }

    public void setPage500(String page500) {
        this.page500 = page500;
    }

    public Map<String, Set<String>> getStaticPathsMap() {
        this.initStaticPaths();
        return this.staticPathsMap;
    }

    public Set<String> getStaticPaths() {
        this.initStaticPaths();
        return this.staticPaths;
    }

    private Map<String, Set<String>> initStaticPaths() {
        String pageRootAbs;
        if (this.staticPathsMap != null) {
            return this.staticPathsMap;
        }
        if (this.pageInClasspath) {
            throw new RuntimeException("classpath\u7684pageRoot\u662f");
        }
        this.staticPathsMap = new TreeMap<String, Set<String>>();
        this.staticPaths = new TreeSet<String>();
        List files = FileUtil.loopFiles((String)this.pageRoot, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File file) {
                String filename = file.getName();
                String ext = FileUtil.extName((String)filename);
                if (file.isDirectory()) {
                    return !"svn-base".equalsIgnoreCase(ext);
                }
                return true;
            }
        });
        if (files == null) {
            return this.staticPathsMap;
        }
        if (log.isInfoEnabled()) {
            log.info("\u4e00\u5171{}\u4e2a\u6587\u4ef6", (Object)files.size());
        }
        File pageRootFile = new File(this.pageRoot);
        try {
            pageRootAbs = pageRootFile.getCanonicalPath();
        }
        catch (IOException e1) {
            log.error(e1.toString(), (Throwable)e1);
            return null;
        }
        for (File file : files) {
            try {
                if (file.isDirectory()) continue;
                String absPath = file.getCanonicalPath();
                Object path = absPath.substring(pageRootAbs.length());
                if (!((String)(path = ((String)path).replaceAll("\\\\", "/"))).startsWith("/")) {
                    path = "/" + (String)path;
                }
                log.info("\u8bbf\u95ee\u8def\u5f84:{}", path);
                String ext = FileUtil.extName((String)path);
                Set<String> set = this.staticPathsMap.get(ext);
                if (set == null) {
                    set = new TreeSet<String>();
                    this.staticPathsMap.put(ext, set);
                }
                set.add((String)path);
                this.staticPaths.add((String)path);
            }
            catch (Exception e) {
                log.error(e.toString());
            }
        }
        return this.staticPathsMap;
    }

    public String getPath(File file) throws IOException {
        String absPath = file.getCanonicalPath();
        File pageRootFile = new File(this.pageRoot);
        String pageRootAbs = pageRootFile.getCanonicalPath();
        Object path = absPath.substring(pageRootAbs.length());
        if (!((String)(path = ((String)path).replaceAll("\\\\", "/"))).startsWith("/")) {
            path = "/" + (String)path;
        }
        return path;
    }

    public void setPageRoot(String pageRoot) throws IOException {
        this.staticPathsMap = null;
        if (StrUtil.startWith((CharSequence)pageRoot, (CharSequence)"classpath:")) {
            this.pageRoot = pageRoot.substring("classpath:".length());
            if (this.pageRoot.startsWith("/")) {
                this.pageRoot = this.pageRoot.substring(1);
            }
            this.pageInClasspath = true;
        } else {
            this.pageRoot = pageRoot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDomainPage(String domain, String pageRoot) throws IOException {
        if (this.domainPageMap == null) {
            HttpConfig httpConfig = this;
            synchronized (httpConfig) {
                if (this.domainPageMap == null) {
                    this.domainPageMap = new HashMap<String, String>();
                }
            }
        }
        this.domainPageMap.put(domain, pageRoot);
        if (this.freemarkerConfig != null) {
            this.freemarkerConfig.addDomainConfiguration(domain, pageRoot);
        }
    }

    public void setServerInfo(String serverInfo) {
        this.serverInfo = serverInfo;
    }

    public void setSessionCacheName(String sessionCacheName) {
        this.sessionCacheName = sessionCacheName;
    }

    public void setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
    }

    public void setSessionIdGenerator(ISessionIdGenerator sessionIdGenerator) {
        this.sessionIdGenerator = sessionIdGenerator;
    }

    public void setSessionStore(ICache sessionStore) {
        this.sessionStore = sessionStore;
    }

    public HttpRequestHandler getHttpRequestHandler() {
        return this.httpRequestHandler;
    }

    public void setHttpRequestHandler(HttpRequestHandler httpRequestHandler) {
        this.httpRequestHandler = httpRequestHandler;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String[] getAllowDomains() {
        return this.allowDomains;
    }

    public void setAllowDomains(String[] allowDomains) {
        this.allowDomains = allowDomains;
    }

    public boolean isProxied() {
        return this.isProxied;
    }

    public void setProxied(boolean isProxied) {
        this.isProxied = isProxied;
    }

    public boolean isUseSession() {
        return this.useSession;
    }

    public void setUseSession(boolean useSession) {
        this.useSession = useSession;
    }

    public HttpSession getHttpSession(String sessionId) {
        if (StrUtil.isBlank((CharSequence)sessionId)) {
            return null;
        }
        HttpSession httpSession = (HttpSession)this.getSessionStore().get(sessionId);
        return httpSession;
    }

    public String getWelcomeFile() {
        return this.welcomeFile;
    }

    public void setWelcomeFile(String welcomeFile) {
        this.welcomeFile = welcomeFile;
    }

    public FreemarkerConfig getFreemarkerConfig() {
        return this.freemarkerConfig;
    }

    public void setFreemarkerConfig(FreemarkerConfig freemarkerConfig) {
        this.freemarkerConfig = freemarkerConfig;
    }

    public boolean isAppendRequestHeaderString() {
        return this.appendRequestHeaderString;
    }

    public void setAppendRequestHeaderString(boolean appendRequestHeaderString) {
        this.appendRequestHeaderString = appendRequestHeaderString;
    }

    public int getMaxLengthOfMultiBody() {
        return this.maxLengthOfMultiBody;
    }

    public void setMaxLengthOfMultiBody(int maxLengthOfMultiBody) {
        this.maxLengthOfMultiBody = maxLengthOfMultiBody;
    }

    public HttpResponse getRespForBlackIp() {
        return this.respForBlackIp;
    }

    public void setRespForBlackIp(HttpResponse respForBlackIp) {
        this.respForBlackIp = respForBlackIp;
    }

    public void setCheckHost(boolean checkHost) {
        this.checkHost = checkHost;
    }

    public void setCompatible1_0(boolean compatible1_0) {
        this.compatible1_0 = compatible1_0;
    }

    public boolean isPageInClasspath() {
        return this.pageInClasspath;
    }

    public void setPageInClasspath(boolean pageInClasspath) {
        this.pageInClasspath = pageInClasspath;
    }

    public SessionRateLimiter getSessionRateLimiter() {
        return this.sessionRateLimiter;
    }

    public void setSessionRateLimiter(SessionRateLimiter sessionRateLimiter) {
        this.sessionRateLimiter = sessionRateLimiter;
    }

    public int getMaxForwardCount() {
        return this.maxForwardCount;
    }

    public void setMaxForwardCount(int maxForwardCount) {
        this.maxForwardCount = maxForwardCount;
    }

    public int getMaxLengthOfPostBody() {
        return this.maxLengthOfPostBody;
    }

    public void setMaxLengthOfPostBody(int maxLengthOfPostBody) {
        this.maxLengthOfPostBody = maxLengthOfPostBody;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getJsonpParamName() {
        return this.jsonpParamName;
    }

    public void setJsonpParamName(String jsonpParamName) {
        this.jsonpParamName = jsonpParamName;
    }

    public boolean isMonitorFileChange() {
        return this.monitorFileChange;
    }

    public void setMonitorFileChange(boolean monitorFileChange) {
        this.monitorFileChange = monitorFileChange;
    }
}

