/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.HashUtils;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.lock.LockUtils;

public class StrCache {
    private static Logger log = LoggerFactory.getLogger(StrCache.class);
    private static final int MAX_SIZE = 5000;
    private static final Map<Integer, String> BYTES_STRING_MAP = new HashMap<Integer, String>(100);
    private static final Map<Integer, String> INIT_LOWERCASE_MAP = new HashMap<Integer, String>(100);

    public static String get(byte[] allbs, int start, int len) {
        int hashcode = HashUtils.hash31((byte[])allbs, (int)start, (int)len);
        String str = BYTES_STRING_MAP.get(hashcode);
        if (str == null) {
            if (BYTES_STRING_MAP.size() > 5000) {
                return new String(allbs, start, len);
            }
            try {
                LockUtils.runWriteOrWaitRead((String)("StrCache:getBytes" + hashcode), BYTES_STRING_MAP, () -> {
                    String str2 = BYTES_STRING_MAP.get(hashcode);
                    if (str2 == null) {
                        str2 = new String(allbs, start, len);
                        BYTES_STRING_MAP.put(hashcode, str2);
                    }
                });
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
            str = BYTES_STRING_MAP.get(hashcode);
        }
        return str;
    }

    public static String getLowercase(String initStr) {
        if (StrUtil.isBlank((CharSequence)initStr)) {
            return initStr;
        }
        int hashcode = initStr.hashCode();
        String str = INIT_LOWERCASE_MAP.get(hashcode);
        if (str == null) {
            if (INIT_LOWERCASE_MAP.size() > 5000) {
                return initStr.toLowerCase();
            }
            try {
                LockUtils.runWriteOrWaitRead((String)("StrCache:getLowercase" + hashcode), INIT_LOWERCASE_MAP, () -> {
                    String str2 = INIT_LOWERCASE_MAP.get(hashcode);
                    if (str2 == null) {
                        str2 = initStr.toLowerCase();
                        INIT_LOWERCASE_MAP.put(hashcode, str2);
                    }
                });
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
            str = INIT_LOWERCASE_MAP.get(hashcode);
        }
        return str;
    }
}

