/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import org.tensorflow.Operand;
import org.tensorflow.op.Scope;
import org.tensorflow.op.linalg.BandPart;
import org.tensorflow.op.linalg.BatchCholesky;
import org.tensorflow.op.linalg.BatchCholeskyGrad;
import org.tensorflow.op.linalg.BatchMatMul;
import org.tensorflow.op.linalg.BatchMatrixBandPart;
import org.tensorflow.op.linalg.BatchMatrixDeterminant;
import org.tensorflow.op.linalg.BatchMatrixDiag;
import org.tensorflow.op.linalg.BatchMatrixDiagPart;
import org.tensorflow.op.linalg.BatchMatrixInverse;
import org.tensorflow.op.linalg.BatchMatrixSetDiag;
import org.tensorflow.op.linalg.BatchMatrixSolve;
import org.tensorflow.op.linalg.BatchMatrixSolveLs;
import org.tensorflow.op.linalg.BatchMatrixTriangularSolve;
import org.tensorflow.op.linalg.BatchSelfAdjointEig;
import org.tensorflow.op.linalg.BatchSvd;
import org.tensorflow.op.linalg.Cholesky;
import org.tensorflow.op.linalg.CholeskyGrad;
import org.tensorflow.op.linalg.ConjugateTranspose;
import org.tensorflow.op.linalg.Cross;
import org.tensorflow.op.linalg.Det;
import org.tensorflow.op.linalg.Diag;
import org.tensorflow.op.linalg.DiagPart;
import org.tensorflow.op.linalg.Inv;
import org.tensorflow.op.linalg.LoadAndRemapMatrix;
import org.tensorflow.op.linalg.LogMatrixDeterminant;
import org.tensorflow.op.linalg.MatMul;
import org.tensorflow.op.linalg.MatrixSolveLs;
import org.tensorflow.op.linalg.Qr;
import org.tensorflow.op.linalg.QuantizedMatMul;
import org.tensorflow.op.linalg.SelfAdjointEig;
import org.tensorflow.op.linalg.SetDiag;
import org.tensorflow.op.linalg.Solve;
import org.tensorflow.op.linalg.Sqrtm;
import org.tensorflow.op.linalg.Svd;
import org.tensorflow.op.linalg.TensorDiag;
import org.tensorflow.op.linalg.TensorDiagPart;
import org.tensorflow.op.linalg.Transpose;
import org.tensorflow.op.linalg.TriangularSolve;

public final class LinalgOps {
    private final Scope scope;

    LinalgOps(Scope scope) {
        this.scope = scope;
    }

    public <T> Qr<T> qr(Operand<T> input, Qr.Options ... options) {
        return Qr.create(this.scope, input, options);
    }

    public <T extends Number> BatchMatrixInverse<T> batchMatrixInverse(Operand<T> input, BatchMatrixInverse.Options ... options) {
        return BatchMatrixInverse.create(this.scope, input, options);
    }

    public <T extends Number> BatchCholesky<T> batchCholesky(Operand<T> input) {
        return BatchCholesky.create(this.scope, input);
    }

    public <T extends Number> BatchSelfAdjointEig<T> batchSelfAdjointEig(Operand<T> input, BatchSelfAdjointEig.Options ... options) {
        return BatchSelfAdjointEig.create(this.scope, input, options);
    }

    public <T> TensorDiag<T> tensorDiag(Operand<T> diagonal) {
        return TensorDiag.create(this.scope, diagonal);
    }

    public <T, U extends Number> ConjugateTranspose<T> conjugateTranspose(Operand<T> x, Operand<U> perm) {
        return ConjugateTranspose.create(this.scope, x, perm);
    }

    public <T> BatchMatrixDeterminant<T> batchMatrixDeterminant(Operand<T> input) {
        return BatchMatrixDeterminant.create(this.scope, input);
    }

    public <T extends Number> BatchMatrixSolve<T> batchMatrixSolve(Operand<T> matrix, Operand<T> rhs, BatchMatrixSolve.Options ... options) {
        return BatchMatrixSolve.create(this.scope, matrix, rhs, options);
    }

    public <T extends Number> BatchCholeskyGrad<T> batchCholeskyGrad(Operand<T> l, Operand<T> grad) {
        return BatchCholeskyGrad.create(this.scope, l, grad);
    }

    public <T extends Number> BatchMatrixSolveLs<T> batchMatrixSolveLs(Operand<T> matrix, Operand<T> rhs, Operand<Double> l2Regularizer, BatchMatrixSolveLs.Options ... options) {
        return BatchMatrixSolveLs.create(this.scope, matrix, rhs, l2Regularizer, options);
    }

    public <T> TensorDiagPart<T> tensorDiagPart(Operand<T> input) {
        return TensorDiagPart.create(this.scope, input);
    }

    public <T> Sqrtm<T> sqrtm(Operand<T> input) {
        return Sqrtm.create(this.scope, input);
    }

    public <T> Cholesky<T> cholesky(Operand<T> input) {
        return Cholesky.create(this.scope, input);
    }

    public <T> Det<T> det(Operand<T> input) {
        return Det.create(this.scope, input);
    }

    public <T> Svd<T> svd(Operand<T> input, Svd.Options ... options) {
        return Svd.create(this.scope, input, options);
    }

    public <T extends Number> Cross<T> cross(Operand<T> a, Operand<T> b) {
        return Cross.create(this.scope, a, b);
    }

    public <T> LogMatrixDeterminant<T> logMatrixDeterminant(Operand<T> input) {
        return LogMatrixDeterminant.create(this.scope, input);
    }

    public <T> TriangularSolve<T> triangularSolve(Operand<T> matrix, Operand<T> rhs, TriangularSolve.Options ... options) {
        return TriangularSolve.create(this.scope, matrix, rhs, options);
    }

    public <T> DiagPart<T> diagPart(Operand<T> input) {
        return DiagPart.create(this.scope, input);
    }

    public <T> SetDiag<T> setDiag(Operand<T> input, Operand<T> diagonal) {
        return SetDiag.create(this.scope, input, diagonal);
    }

    public <T extends Number> CholeskyGrad<T> choleskyGrad(Operand<T> l, Operand<T> grad) {
        return CholeskyGrad.create(this.scope, l, grad);
    }

    public <T> Solve<T> solve(Operand<T> matrix, Operand<T> rhs, Solve.Options ... options) {
        return Solve.create(this.scope, matrix, rhs, options);
    }

    public <V, T, U, W> QuantizedMatMul<V> quantizedMatMul(Operand<T> a, Operand<U> b, Operand<Float> minA, Operand<Float> maxA, Operand<Float> minB, Operand<Float> maxB, Class<V> Toutput, Class<W> Tactivation, QuantizedMatMul.Options ... options) {
        return QuantizedMatMul.create(this.scope, a, b, minA, maxA, minB, maxB, Toutput, Tactivation, options);
    }

    public <T> BatchMatrixSetDiag<T> batchMatrixSetDiag(Operand<T> input, Operand<T> diagonal) {
        return BatchMatrixSetDiag.create(this.scope, input, diagonal);
    }

    public <T, U extends Number> Transpose<T> transpose(Operand<T> x, Operand<U> perm) {
        return Transpose.create(this.scope, x, perm);
    }

    public <T> BatchSvd<T> batchSvd(Operand<T> input, BatchSvd.Options ... options) {
        return BatchSvd.create(this.scope, input, options);
    }

    public <T> MatrixSolveLs<T> matrixSolveLs(Operand<T> matrix, Operand<T> rhs, Operand<Double> l2Regularizer, MatrixSolveLs.Options ... options) {
        return MatrixSolveLs.create(this.scope, matrix, rhs, l2Regularizer, options);
    }

    public <T> BatchMatrixDiagPart<T> batchMatrixDiagPart(Operand<T> input) {
        return BatchMatrixDiagPart.create(this.scope, input);
    }

    public LoadAndRemapMatrix loadAndRemapMatrix(Operand<String> ckptPath, Operand<String> oldTensorName, Operand<Long> rowRemapping, Operand<Long> colRemapping, Operand<Float> initializingValues, Long numRows, Long numCols, LoadAndRemapMatrix.Options ... options) {
        return LoadAndRemapMatrix.create(this.scope, ckptPath, oldTensorName, rowRemapping, colRemapping, initializingValues, numRows, numCols, options);
    }

    public <T> Inv<T> inv(Operand<T> input, Inv.Options ... options) {
        return Inv.create(this.scope, input, options);
    }

    public <T extends Number> BatchMatrixTriangularSolve<T> batchMatrixTriangularSolve(Operand<T> matrix, Operand<T> rhs, BatchMatrixTriangularSolve.Options ... options) {
        return BatchMatrixTriangularSolve.create(this.scope, matrix, rhs, options);
    }

    public <T> MatMul<T> matMul(Operand<T> a, Operand<T> b, MatMul.Options ... options) {
        return MatMul.create(this.scope, a, b, options);
    }

    public <T> BatchMatrixBandPart<T> batchMatrixBandPart(Operand<T> input, Operand<Long> numLower, Operand<Long> numUpper) {
        return BatchMatrixBandPart.create(this.scope, input, numLower, numUpper);
    }

    public <T> Diag<T> diag(Operand<T> diagonal) {
        return Diag.create(this.scope, diagonal);
    }

    public <T> BatchMatrixDiag<T> batchMatrixDiag(Operand<T> diagonal) {
        return BatchMatrixDiag.create(this.scope, diagonal);
    }

    public <T, U extends Number> BandPart<T> bandPart(Operand<T> input, Operand<U> numLower, Operand<U> numUpper) {
        return BandPart.create(this.scope, input, numLower, numUpper);
    }

    public <T> SelfAdjointEig<T> selfAdjointEig(Operand<T> input, SelfAdjointEig.Options ... options) {
        return SelfAdjointEig.create(this.scope, input, options);
    }

    public <T> BatchMatMul<T> batchMatMul(Operand<T> x, Operand<T> y, BatchMatMul.Options ... options) {
        return BatchMatMul.create(this.scope, x, y, options);
    }
}

