/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import org.tensorflow.Operand;
import org.tensorflow.op.Scope;
import org.tensorflow.op.random.AllCandidateSampler;
import org.tensorflow.op.random.LogUniformCandidateSampler;
import org.tensorflow.op.random.Multinomial;
import org.tensorflow.op.random.ParameterizedTruncatedNormal;
import org.tensorflow.op.random.RandomGamma;
import org.tensorflow.op.random.RandomPoisson;
import org.tensorflow.op.random.RandomShuffle;
import org.tensorflow.op.random.RandomStandardNormal;
import org.tensorflow.op.random.RandomUniform;
import org.tensorflow.op.random.RandomUniformInt;
import org.tensorflow.op.random.RecordInput;
import org.tensorflow.op.random.StatelessMultinomial;
import org.tensorflow.op.random.StatelessRandomNormal;
import org.tensorflow.op.random.StatelessRandomUniform;
import org.tensorflow.op.random.StatelessTruncatedNormal;
import org.tensorflow.op.random.TruncatedNormal;
import org.tensorflow.op.random.UniformCandidateSampler;

public final class RandomOps {
    private final Scope scope;

    RandomOps(Scope scope) {
        this.scope = scope;
    }

    public <T> RandomShuffle<T> randomShuffle(Operand<T> value, RandomShuffle.Options ... options) {
        return RandomShuffle.create(this.scope, value, options);
    }

    public <T extends Number> Multinomial<Long> multinomial(Operand<T> logits, Operand<Integer> numSamples, Multinomial.Options ... options) {
        return Multinomial.create(this.scope, logits, numSamples, options);
    }

    public <T extends Number, U extends Number> StatelessRandomUniform<Float> statelessRandomUniform(Operand<T> shape, Operand<U> seed) {
        return StatelessRandomUniform.create(this.scope, shape, seed);
    }

    public <V extends Number, T extends Number, U extends Number> StatelessRandomNormal<V> statelessRandomNormal(Operand<T> shape, Operand<U> seed, Class<V> dtype) {
        return StatelessRandomNormal.create(this.scope, shape, seed, dtype);
    }

    public UniformCandidateSampler uniformCandidateSampler(Operand<Long> trueClasses, Long numTrue, Long numSampled, Boolean unique, Long rangeMax, UniformCandidateSampler.Options ... options) {
        return UniformCandidateSampler.create(this.scope, trueClasses, numTrue, numSampled, unique, rangeMax, options);
    }

    public <U extends Number, T extends Number> RandomGamma<U> randomGamma(Operand<T> shape, Operand<U> alpha, RandomGamma.Options ... options) {
        return RandomGamma.create(this.scope, shape, alpha, options);
    }

    public <U extends Number, T extends Number> RandomUniformInt<U> randomUniformInt(Operand<T> shape, Operand<U> minval, Operand<U> maxval, RandomUniformInt.Options ... options) {
        return RandomUniformInt.create(this.scope, shape, minval, maxval, options);
    }

    public <V extends Number, T extends Number, U extends Number> StatelessTruncatedNormal<V> statelessTruncatedNormal(Operand<T> shape, Operand<U> seed, Class<V> dtype) {
        return StatelessTruncatedNormal.create(this.scope, shape, seed, dtype);
    }

    public <V extends Number, T extends Number, U extends Number> StatelessMultinomial<V> statelessMultinomial(Operand<T> logits, Operand<Integer> numSamples, Operand<U> seed, Class<V> outputDtype) {
        return StatelessMultinomial.create(this.scope, logits, numSamples, seed, outputDtype);
    }

    public <T extends Number, U extends Number> RandomPoisson<Long> randomPoisson(Operand<T> shape, Operand<U> rate, RandomPoisson.Options ... options) {
        return RandomPoisson.create(this.scope, shape, rate, options);
    }

    public <T extends Number, U extends Number> StatelessMultinomial<Long> statelessMultinomial(Operand<T> logits, Operand<Integer> numSamples, Operand<U> seed) {
        return StatelessMultinomial.create(this.scope, logits, numSamples, seed);
    }

    public <U extends Number, T extends Number> RandomUniform<U> randomUniform(Operand<T> shape, Class<U> dtype, RandomUniform.Options ... options) {
        return RandomUniform.create(this.scope, shape, dtype, options);
    }

    public <T extends Number, U extends Number> StatelessRandomNormal<Float> statelessRandomNormal(Operand<T> shape, Operand<U> seed) {
        return StatelessRandomNormal.create(this.scope, shape, seed);
    }

    public <U extends Number, T extends Number> Multinomial<U> multinomial(Operand<T> logits, Operand<Integer> numSamples, Class<U> outputDtype, Multinomial.Options ... options) {
        return Multinomial.create(this.scope, logits, numSamples, outputDtype, options);
    }

    public AllCandidateSampler allCandidateSampler(Operand<Long> trueClasses, Long numTrue, Long numSampled, Boolean unique, AllCandidateSampler.Options ... options) {
        return AllCandidateSampler.create(this.scope, trueClasses, numTrue, numSampled, unique, options);
    }

    public <U extends Number, T extends Number> ParameterizedTruncatedNormal<U> parameterizedTruncatedNormal(Operand<T> shape, Operand<U> means, Operand<U> stdevs, Operand<U> minvals, Operand<U> maxvals, ParameterizedTruncatedNormal.Options ... options) {
        return ParameterizedTruncatedNormal.create(this.scope, shape, means, stdevs, minvals, maxvals, options);
    }

    public <V extends Number, T extends Number, U extends Number> RandomPoisson<V> randomPoisson(Operand<T> shape, Operand<U> rate, Class<V> dtype, RandomPoisson.Options ... options) {
        return RandomPoisson.create(this.scope, shape, rate, dtype, options);
    }

    public <U extends Number, T extends Number> TruncatedNormal<U> truncatedNormal(Operand<T> shape, Class<U> dtype, TruncatedNormal.Options ... options) {
        return TruncatedNormal.create(this.scope, shape, dtype, options);
    }

    public <T extends Number, U extends Number> StatelessTruncatedNormal<Float> statelessTruncatedNormal(Operand<T> shape, Operand<U> seed) {
        return StatelessTruncatedNormal.create(this.scope, shape, seed);
    }

    public LogUniformCandidateSampler logUniformCandidateSampler(Operand<Long> trueClasses, Long numTrue, Long numSampled, Boolean unique, Long rangeMax, LogUniformCandidateSampler.Options ... options) {
        return LogUniformCandidateSampler.create(this.scope, trueClasses, numTrue, numSampled, unique, rangeMax, options);
    }

    public <V extends Number, T extends Number, U extends Number> StatelessRandomUniform<V> statelessRandomUniform(Operand<T> shape, Operand<U> seed, Class<V> dtype) {
        return StatelessRandomUniform.create(this.scope, shape, seed, dtype);
    }

    public RecordInput recordInput(String filePattern, RecordInput.Options ... options) {
        return RecordInput.create(this.scope, filePattern, options);
    }

    public <U extends Number, T extends Number> RandomStandardNormal<U> randomStandardNormal(Operand<T> shape, Class<U> dtype, RandomStandardNormal.Options ... options) {
        return RandomStandardNormal.create(this.scope, shape, dtype, options);
    }
}

