/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.op.Scope;
import org.tensorflow.op.strings.Join;
import org.tensorflow.op.strings.ReduceJoin;
import org.tensorflow.op.strings.RegexFullMatch;
import org.tensorflow.op.strings.RegexReplace;
import org.tensorflow.op.strings.StringFormat;
import org.tensorflow.op.strings.StringLength;
import org.tensorflow.op.strings.StringSplit;
import org.tensorflow.op.strings.Strip;
import org.tensorflow.op.strings.Substr;
import org.tensorflow.op.strings.ToHashBucket;
import org.tensorflow.op.strings.ToHashBucketFast;
import org.tensorflow.op.strings.ToHashBucketStrong;
import org.tensorflow.op.strings.ToNumber;
import org.tensorflow.op.strings.UnicodeScript;
import org.tensorflow.op.strings.UnicodeTranscode;

public final class StringsOps {
    private final Scope scope;

    StringsOps(Scope scope) {
        this.scope = scope;
    }

    public <T extends Number> ToNumber<T> toNumber(Operand<String> stringTensor, Class<T> outType) {
        return ToNumber.create(this.scope, stringTensor, outType);
    }

    public StringFormat stringFormat(Iterable<Operand<?>> inputs, StringFormat.Options ... options) {
        return StringFormat.create(this.scope, inputs, options);
    }

    public UnicodeTranscode unicodeTranscode(Operand<String> input, String inputEncoding, String outputEncoding, UnicodeTranscode.Options ... options) {
        return UnicodeTranscode.create(this.scope, input, inputEncoding, outputEncoding, options);
    }

    public ToHashBucket toHashBucket(Operand<String> stringTensor, Long numBuckets) {
        return ToHashBucket.create(this.scope, stringTensor, numBuckets);
    }

    public StringLength stringLength(Operand<String> input, StringLength.Options ... options) {
        return StringLength.create(this.scope, input, options);
    }

    public ToNumber<Float> toNumber(Operand<String> stringTensor) {
        return ToNumber.create(this.scope, stringTensor);
    }

    public UnicodeScript unicodeScript(Operand<Integer> input) {
        return UnicodeScript.create(this.scope, input);
    }

    public Strip strip(Operand<String> input) {
        return Strip.create(this.scope, input);
    }

    public StringSplit stringSplit(Operand<String> input, Operand<String> sep, StringSplit.Options ... options) {
        return StringSplit.create(this.scope, input, sep, options);
    }

    public RegexReplace regexReplace(Operand<String> input, Operand<String> pattern, Operand<String> rewrite, RegexReplace.Options ... options) {
        return RegexReplace.create(this.scope, input, pattern, rewrite, options);
    }

    public ToHashBucketStrong toHashBucketStrong(Operand<String> input, Long numBuckets, List<Long> key) {
        return ToHashBucketStrong.create(this.scope, input, numBuckets, key);
    }

    public <T extends Number> Substr substr(Operand<String> input, Operand<T> pos, Operand<T> len, Substr.Options ... options) {
        return Substr.create(this.scope, input, pos, len, options);
    }

    public RegexFullMatch regexFullMatch(Operand<String> input, Operand<String> pattern) {
        return RegexFullMatch.create(this.scope, input, pattern);
    }

    public ToHashBucketFast toHashBucketFast(Operand<String> input, Long numBuckets) {
        return ToHashBucketFast.create(this.scope, input, numBuckets);
    }

    public Join join(Iterable<Operand<String>> inputs, Join.Options ... options) {
        return Join.create(this.scope, inputs, options);
    }

    public ReduceJoin reduceJoin(Operand<String> inputs, Operand<Integer> reductionIndices, ReduceJoin.Options ... options) {
        return ReduceJoin.create(this.scope, inputs, reductionIndices, options);
    }
}

