/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizedConcat<T>
extends PrimitiveOp {
    private Output<T> output;
    private Output<Float> outputMin;
    private Output<Float> outputMax;

    public static <T> QuantizedConcat<T> create(Scope scope, Operand<Integer> concatDim, Iterable<Operand<T>> values, Iterable<Operand<Float>> inputMins, Iterable<Operand<Float>> inputMaxes) {
        OperationBuilder opBuilder = scope.env().opBuilder("QuantizedConcat", scope.makeOpName("QuantizedConcat"));
        opBuilder.addInput(concatDim.asOutput());
        opBuilder.addInputList(Operands.asOutputs(values));
        opBuilder.addInputList(Operands.asOutputs(inputMins));
        opBuilder.addInputList(Operands.asOutputs(inputMaxes));
        opBuilder = scope.applyControlDependencies(opBuilder);
        return new QuantizedConcat<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    public Output<Float> outputMin() {
        return this.outputMin;
    }

    public Output<Float> outputMax() {
        return this.outputMax;
    }

    private QuantizedConcat(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.outputMin = operation.output(outputIdx++);
        this.outputMax = operation.output(outputIdx++);
    }
}

