/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizedBatchNormWithGlobalNormalization<U>
extends PrimitiveOp {
    private Output<U> result;
    private Output<Float> resultMin;
    private Output<Float> resultMax;

    public static <U, T> QuantizedBatchNormWithGlobalNormalization<U> create(Scope scope, Operand<T> t, Operand<Float> tMin, Operand<Float> tMax, Operand<T> m, Operand<Float> mMin, Operand<Float> mMax, Operand<T> v, Operand<Float> vMin, Operand<Float> vMax, Operand<T> beta, Operand<Float> betaMin, Operand<Float> betaMax, Operand<T> gamma, Operand<Float> gammaMin, Operand<Float> gammaMax, Class<U> outType, Float varianceEpsilon, Boolean scaleAfterNormalization) {
        OperationBuilder opBuilder = scope.env().opBuilder("QuantizedBatchNormWithGlobalNormalization", scope.makeOpName("QuantizedBatchNormWithGlobalNormalization"));
        opBuilder.addInput(t.asOutput());
        opBuilder.addInput(tMin.asOutput());
        opBuilder.addInput(tMax.asOutput());
        opBuilder.addInput(m.asOutput());
        opBuilder.addInput(mMin.asOutput());
        opBuilder.addInput(mMax.asOutput());
        opBuilder.addInput(v.asOutput());
        opBuilder.addInput(vMin.asOutput());
        opBuilder.addInput(vMax.asOutput());
        opBuilder.addInput(beta.asOutput());
        opBuilder.addInput(betaMin.asOutput());
        opBuilder.addInput(betaMax.asOutput());
        opBuilder.addInput(gamma.asOutput());
        opBuilder.addInput(gammaMin.asOutput());
        opBuilder.addInput(gammaMax.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("out_type", DataType.fromClass(outType));
        opBuilder.setAttr("variance_epsilon", varianceEpsilon.floatValue());
        opBuilder.setAttr("scale_after_normalization", scaleAfterNormalization);
        return new QuantizedBatchNormWithGlobalNormalization<U>(opBuilder.build());
    }

    public Output<U> result() {
        return this.result;
    }

    public Output<Float> resultMin() {
        return this.resultMin;
    }

    public Output<Float> resultMax() {
        return this.resultMax;
    }

    private QuantizedBatchNormWithGlobalNormalization(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.result = operation.output(outputIdx++);
        this.resultMin = operation.output(outputIdx++);
        this.resultMax = operation.output(outputIdx++);
    }
}

