/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.diff;

import java.util.Map;
import java.util.TreeMap;
import org.test4j.hamcrest.diff.BaseDiff;

public class DiffMap {
    int diff = 0;
    int ignoreCount = 0;
    Map<String, String> message = new TreeMap<String, String>();

    public DiffMap add(Object key, Object actual, Object expect) {
        this.message.put(String.valueOf(key), this.diffString(actual, expect));
        ++this.diff;
        return this;
    }

    public DiffMap add(DiffMap nested) {
        if (nested.diff == 0) {
            return this;
        }
        for (Map.Entry<String, String> entry : nested.message.entrySet()) {
            String key = entry.getKey();
            if (this.message.containsKey(key)) {
                this.message.put(key, this.message.get(key) + "; " + entry.getValue());
                continue;
            }
            this.message.put(key, entry.getValue());
        }
        this.diff += nested.diff;
        return this;
    }

    public void addIgnore() {
        ++this.ignoreCount;
    }

    public String diffString(Object actual, Object expect) {
        return "\n\texpect=" + BaseDiff.asString(expect) + "\n\tactual=" + BaseDiff.asString(actual) + "";
    }

    public String message() {
        StringBuffer buff = new StringBuffer("\n");
        for (Map.Entry<String, String> entry : this.message.entrySet()) {
            buff.append(entry.getKey()).append(":").append(entry.getValue()).append("\n");
        }
        return buff.toString();
    }

    public boolean hasDiff() {
        return this.diff > 0;
    }

    public int diffCount() {
        return this.message.size();
    }

    public int getDiff() {
        return this.diff;
    }

    public int getIgnoreCount() {
        return this.ignoreCount;
    }

    public Map<String, String> getMessage() {
        return this.message;
    }

    public DiffMap setDiff(int diff) {
        this.diff = diff;
        return this;
    }

    public DiffMap setIgnoreCount(int ignoreCount) {
        this.ignoreCount = ignoreCount;
        return this;
    }

    public DiffMap setMessage(Map<String, String> message) {
        this.message = message;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DiffMap)) {
            return false;
        }
        DiffMap other = (DiffMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDiff() != other.getDiff()) {
            return false;
        }
        if (this.getIgnoreCount() != other.getIgnoreCount()) {
            return false;
        }
        Map<String, String> this$message = this.getMessage();
        Map<String, String> other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DiffMap;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDiff();
        result = result * 59 + this.getIgnoreCount();
        Map<String, String> $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        return result;
    }

    public String toString() {
        return "DiffMap(diff=" + this.getDiff() + ", ignoreCount=" + this.getIgnoreCount() + ", message=" + this.getMessage() + ")";
    }
}

