/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.diff;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.test4j.hamcrest.diff.DiffMap;

public class ListMatchItem {
    private final int actualIndex;
    private Integer expectIndex;
    private final Map<Integer, DiffMap> diffItem;
    private Set<Integer> hasMatchedIndex;

    public ListMatchItem(int actualIndex, Set<Integer> hasMatchedIndex) {
        this.actualIndex = actualIndex;
        this.hasMatchedIndex = hasMatchedIndex;
        this.diffItem = new HashMap<Integer, DiffMap>();
    }

    public boolean addMatched(int expected, DiffMap itemDiff) {
        if (itemDiff.diff == 0) {
            this.expectIndex = expected;
            this.diffItem.clear();
            this.hasMatchedIndex.add(expected);
            return true;
        }
        this.diffItem.put(expected, itemDiff);
        return false;
    }

    public void remove(Set<Integer> matchedSet) {
        for (Integer matched : matchedSet) {
            this.diffItem.remove(matched);
        }
    }

    public boolean hasMatched(int index) {
        return this.hasMatchedIndex.contains(index);
    }

    public int getActualIndex() {
        return this.actualIndex;
    }

    public Integer getExpectIndex() {
        return this.expectIndex;
    }

    public Map<Integer, DiffMap> getDiffItem() {
        return this.diffItem;
    }

    public Set<Integer> getHasMatchedIndex() {
        return this.hasMatchedIndex;
    }

    public void setExpectIndex(Integer expectIndex) {
        this.expectIndex = expectIndex;
    }

    public void setHasMatchedIndex(Set<Integer> hasMatchedIndex) {
        this.hasMatchedIndex = hasMatchedIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListMatchItem)) {
            return false;
        }
        ListMatchItem other = (ListMatchItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getActualIndex() != other.getActualIndex()) {
            return false;
        }
        Integer this$expectIndex = this.getExpectIndex();
        Integer other$expectIndex = other.getExpectIndex();
        if (this$expectIndex == null ? other$expectIndex != null : !((Object)this$expectIndex).equals(other$expectIndex)) {
            return false;
        }
        Map<Integer, DiffMap> this$diffItem = this.getDiffItem();
        Map<Integer, DiffMap> other$diffItem = other.getDiffItem();
        if (this$diffItem == null ? other$diffItem != null : !((Object)this$diffItem).equals(other$diffItem)) {
            return false;
        }
        Set<Integer> this$hasMatchedIndex = this.getHasMatchedIndex();
        Set<Integer> other$hasMatchedIndex = other.getHasMatchedIndex();
        return !(this$hasMatchedIndex == null ? other$hasMatchedIndex != null : !((Object)this$hasMatchedIndex).equals(other$hasMatchedIndex));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListMatchItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getActualIndex();
        Integer $expectIndex = this.getExpectIndex();
        result = result * 59 + ($expectIndex == null ? 43 : ((Object)$expectIndex).hashCode());
        Map<Integer, DiffMap> $diffItem = this.getDiffItem();
        result = result * 59 + ($diffItem == null ? 43 : ((Object)$diffItem).hashCode());
        Set<Integer> $hasMatchedIndex = this.getHasMatchedIndex();
        result = result * 59 + ($hasMatchedIndex == null ? 43 : ((Object)$hasMatchedIndex).hashCode());
        return result;
    }

    public String toString() {
        return "ListMatchItem(actualIndex=" + this.getActualIndex() + ", expectIndex=" + this.getExpectIndex() + ", diffItem=" + this.getDiffItem() + ", hasMatchedIndex=" + this.getHasMatchedIndex() + ")";
    }
}

