/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.iassert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.test4j.functions.SExecutor;
import org.test4j.hamcrest.iassert.impl.StringAssert;
import org.test4j.hamcrest.iassert.intf.IStringAssert;

public class AssertHelper {
    public static IStringAssert exception(SExecutor executor, Class<? extends Throwable> ... eTypes) {
        ArrayList<Class<Exception>> wanted = new ArrayList<Class<Exception>>();
        if (eTypes == null || eTypes.length == 0) {
            wanted.add(Exception.class);
        } else {
            Arrays.stream(eTypes).forEach(wanted::add);
        }
        String expected = wanted.stream().map(Class::getName).collect(Collectors.joining(","));
        try {
            executor.doIt();
            throw new UnExpectedAssertionError("Expected exception: [" + expected + "], but no exception was thrown.");
        }
        catch (UnExpectedAssertionError ue) {
            throw ue;
        }
        catch (Throwable e) {
            boolean matched = false;
            for (Class<? extends Throwable> expectedType : eTypes) {
                if (!expectedType.isAssignableFrom(e.getClass())) continue;
                matched = true;
                break;
            }
            if (matched) {
                return new StringAssert(e.getMessage());
            }
            throw new AssertionError((Object)("Expected exception: [" + expected + "], but actual exception is: " + e.getClass()));
        }
    }

    private static class UnExpectedAssertionError
    extends AssertionError {
        public UnExpectedAssertionError(String error) {
            super((Object)error);
        }
    }
}

