/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.iassert.impl;

import java.util.ArrayList;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.core.AllOf;
import org.test4j.hamcrest.iassert.interal.Assert;
import org.test4j.hamcrest.iassert.interal.IAssert;
import org.test4j.hamcrest.iassert.intf.IMapAssert;
import org.test4j.hamcrest.matcher.array.MapMatcher;

public class MapAssert
extends Assert<Map, IMapAssert>
implements IMapAssert {
    public MapAssert() {
        super(Map.class, (Class<? extends IAssert>)IMapAssert.class);
    }

    public MapAssert(Map map) {
        super(map, Map.class, IMapAssert.class);
    }

    @Override
    public IMapAssert hasKeys(Object key, Object ... keys) {
        return this.hasKeyOrValues(MapMatcher.MapMatcherType.KEY, key, keys);
    }

    @Override
    public IMapAssert hasValues(Object value, Object ... values) {
        return this.hasKeyOrValues(MapMatcher.MapMatcherType.VALUE, value, values);
    }

    private IMapAssert hasKeyOrValues(MapMatcher.MapMatcherType type, Object item, Object ... items) {
        MapMatcher matcher1 = new MapMatcher(item, type);
        if (items == null || items.length == 0) {
            return (IMapAssert)this.assertThat((Matcher)matcher1);
        }
        ArrayList<MapMatcher> list = new ArrayList<MapMatcher>();
        list.add(matcher1);
        for (Object _item : items) {
            list.add(new MapMatcher(_item, type));
        }
        return (IMapAssert)this.assertThat(AllOf.allOf(list));
    }

    @Override
    public IMapAssert hasEntry(Object key, Object value, Object ... objects) {
        Matcher matcher = IsMapContaining.hasEntry((Object)key, (Object)value);
        if (objects == null) {
            return (IMapAssert)this.assertThat(matcher);
        }
        int size = objects.length;
        ArrayList<Matcher> list = new ArrayList<Matcher>();
        list.add(matcher);
        for (int index = 0; index < size / 2; ++index) {
            Matcher matcher2 = IsMapContaining.hasEntry((Object)objects[index * 2], (Object)objects[index * 2 + 1]);
            list.add(matcher2);
        }
        return (IMapAssert)this.assertThat(AllOf.allOf(list));
    }

    @Override
    public IMapAssert hasEntry(Map.Entry<?, ?> entry, Map.Entry<?, ?> ... entries) {
        Matcher matcher = IsMapContaining.hasEntry(entry.getKey(), entry.getValue());
        if (entries == null) {
            return (IMapAssert)this.assertThat(matcher);
        }
        ArrayList<Matcher> list = new ArrayList<Matcher>();
        list.add(matcher);
        for (Map.Entry<?, ?> item : entries) {
            Matcher matcher2 = IsMapContaining.hasEntry(item.getKey(), item.getValue());
            list.add(matcher2);
        }
        return (IMapAssert)this.assertThat(AllOf.allOf(list));
    }
}

