/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.iassert.interal;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIn;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.AnyOf;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsAnything;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.hamcrest.object.HasToString;
import org.test4j.hamcrest.iassert.interal.IAssert;
import org.test4j.hamcrest.iassert.intf.IStringAssert;
import org.test4j.hamcrest.matcher.clazz.ClassAssignFromMatcher;
import org.test4j.hamcrest.matcher.modes.EqMode;
import org.test4j.hamcrest.matcher.property.ReflectionEqualMatcher;
import org.test4j.tools.commons.ListHelper;

public interface IBaseAssert<T, E extends IAssert>
extends Matcher<T>,
IAssert<T, E> {
    default public E eqToString(String expected) {
        Matcher matcher = HasToString.hasToString((String)expected);
        return (E)this.assertThat(matcher);
    }

    default public E eqToString(IStringAssert matcher) {
        Matcher _matcher = HasToString.hasToString((Matcher)matcher);
        return (E)this.assertThat(_matcher);
    }

    default public E eq(T expected) {
        Matcher matcher = IsEqual.equalTo(expected);
        return (E)this.assertThat(matcher);
    }

    default public E eqList(Object ... objs) {
        ReflectionEqualMatcher matcher = new ReflectionEqualMatcher(objs, new EqMode[0]);
        return (E)this.assertThat((Matcher)matcher);
    }

    default public E isEqualTo(T expected) {
        Matcher matcher = IsEqual.equalTo(expected);
        return (E)this.assertThat(matcher);
    }

    default public E isEqualTo(String message, T expected) {
        Object _expected = this.getAssertObject().isNumberAndConvert(expected);
        Matcher matcher = IsEqual.equalTo((Object)_expected);
        return (E)this.assertThat(message, matcher);
    }

    default public E notEqualTo(T expected) {
        Matcher matcher = IsNot.not((Matcher)IsEqual.equalTo(expected));
        return (E)this.assertThat(matcher);
    }

    default public E in(T ... values) {
        Matcher matcher = Matchers.is((Matcher)IsIn.oneOf((Object[])values));
        return (E)this.assertThat(matcher);
    }

    default public E notIn(T ... values) {
        Matcher _matcher = Matchers.is((Matcher)IsIn.oneOf((Object[])values));
        return (E)this.assertThat(_matcher);
    }

    default public E classIs(Class expected) {
        Matcher matcher = Is.isA((Class)expected);
        return (E)this.assertThat(matcher);
    }

    default public E classIsSubFrom(Class clazz) {
        ClassAssignFromMatcher matcher = new ClassAssignFromMatcher(clazz);
        return (E)this.assertThat((Matcher)matcher);
    }

    default public E any(E matcher, E ... matchers) {
        List list = ListHelper.toList(matchers);
        list.add(matcher);
        AnyOf _matcher = AnyOf.anyOf((Iterable)list);
        return (E)this.assertThat((Matcher)_matcher);
    }

    default public E all(E matcher, E ... matchers) {
        List list = ListHelper.toList(matchers);
        list.add(matcher);
        Matcher _matcher = AllOf.allOf((Iterable)list);
        return (E)this.assertThat(_matcher);
    }

    default public E not(E matcher) {
        Matcher _matcher = IsNot.not(matcher);
        return (E)this.assertThat(_matcher);
    }

    default public E notAny(Matcher matcher, Matcher ... matchers) {
        ArrayList<Matcher> ms = new ArrayList<Matcher>();
        ms.add(matcher);
        for (Matcher m : matchers) {
            ms.add(m);
        }
        Matcher _matcher = IsNot.not((Matcher)AnyOf.anyOf(ms));
        return (E)this.assertThat(_matcher);
    }

    default public E notAll(Matcher matcher, Matcher ... matchers) {
        ArrayList<Matcher> ms = new ArrayList<Matcher>();
        ms.add(matcher);
        for (Matcher m : matchers) {
            ms.add(m);
        }
        Matcher _matcher = IsNot.not((Matcher)AllOf.allOf(ms));
        return (E)this.assertThat(_matcher);
    }

    default public E same(T value) {
        Matcher _matcher = IsSame.sameInstance(value);
        return (E)this.assertThat(_matcher);
    }

    default public E any() {
        Matcher _matcher = IsAnything.anything();
        return (E)this.assertThat(_matcher);
    }

    default public E isNull() {
        Matcher _matcher = IsNull.nullValue();
        return (E)this.assertThat(_matcher);
    }

    default public E isNull(String message) {
        Matcher _matcher = IsNull.nullValue();
        return (E)this.assertThat(message, _matcher);
    }

    default public E notNull() {
        Matcher _matcher = IsNull.notNullValue();
        return (E)this.assertThat(_matcher);
    }

    default public E notNull(String message) {
        Matcher _matcher = IsNull.notNullValue();
        return (E)this.assertThat(message, _matcher);
    }
}

