/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.iassert.interal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.AnyOf;
import org.hamcrest.core.IsNot;
import org.test4j.hamcrest.iassert.interal.IAssert;
import org.test4j.hamcrest.matcher.string.StringContainMatcher;
import org.test4j.hamcrest.matcher.string.StringContainsInOrder;
import org.test4j.hamcrest.matcher.string.StringEndWithMatcher;
import org.test4j.hamcrest.matcher.string.StringEqualMatcher;
import org.test4j.hamcrest.matcher.string.StringMode;
import org.test4j.hamcrest.matcher.string.StringNotBlankMatcher;
import org.test4j.hamcrest.matcher.string.StringStartWithMatcher;

public interface ICharAssert<T, E extends ICharAssert>
extends IAssert<T, E> {
    default public E eq(String expected, StringMode ... modes) {
        return this.isEqualTo(expected, modes);
    }

    default public E isEqualTo(String expected, StringMode ... modes) {
        StringEqualMatcher matcher = new StringEqualMatcher(expected);
        matcher.setStringModes(modes);
        return (E)((ICharAssert)this.assertThat((Matcher)matcher));
    }

    default public E contains(String expected, StringMode ... modes) {
        StringContainMatcher matcher = new StringContainMatcher(new String[]{expected}, modes);
        return (E)((ICharAssert)this.assertThat((Matcher)matcher));
    }

    default public E contains(String[] expecteds, StringMode ... modes) {
        StringContainMatcher matcher = new StringContainMatcher(expecteds, modes);
        return (E)((ICharAssert)this.assertThat((Matcher)matcher));
    }

    default public E end(String expected, StringMode ... modes) {
        StringEndWithMatcher matcher = new StringEndWithMatcher(expected);
        matcher.setStringModes(modes);
        return (E)((ICharAssert)this.assertThat((Matcher)matcher));
    }

    default public E start(String expected, StringMode ... modes) {
        StringStartWithMatcher matcher = new StringStartWithMatcher(expected);
        matcher.setStringModes(modes);
        return (E)((ICharAssert)this.assertThat((Matcher)matcher));
    }

    default public E containsInOrder(String ... expecteds) {
        List<String> substrings = Arrays.asList(expecteds);
        StringContainsInOrder matcher = new StringContainsInOrder(substrings);
        return (E)((ICharAssert)this.assertThat((Matcher)matcher));
    }

    default public E containsInOrder(String[] expecteds, StringMode ... modes) {
        List<String> substrings = Arrays.asList(expecteds);
        StringContainsInOrder matcher = new StringContainsInOrder(substrings, modes);
        return (E)((ICharAssert)this.assertThat((Matcher)matcher));
    }

    default public E notContain(String sub, StringMode ... modes) {
        StringContainMatcher matcher = new StringContainMatcher(new String[]{sub}, modes);
        Matcher _matcher = IsNot.not((Matcher)matcher);
        return (E)((ICharAssert)this.assertThat(_matcher));
    }

    default public E notContain(String[] subs, StringMode ... modes) {
        ArrayList<StringContainMatcher> matchers = new ArrayList<StringContainMatcher>();
        for (String sub : subs) {
            StringContainMatcher matcher = new StringContainMatcher(new String[]{sub}, modes);
            matchers.add(matcher);
        }
        Matcher _matcher = IsNot.not((Matcher)AnyOf.anyOf(matchers));
        return (E)((ICharAssert)this.assertThat(_matcher));
    }

    default public E eqIgnoreCase(String string) {
        StringEqualMatcher matcher = new StringEqualMatcher(string);
        matcher.setStringModes(StringMode.IgnoreCase);
        return (E)((ICharAssert)this.assertThat((Matcher)matcher));
    }

    default public E eqIgnoreSpace(String string) {
        StringEqualMatcher matcher = new StringEqualMatcher(string);
        matcher.setStringModes(StringMode.IgnoreSpace);
        return (E)((ICharAssert)this.assertThat("expect equal when ignore all space.", (Matcher)matcher));
    }

    default public E eqWithStripSpace(String string) {
        StringEqualMatcher matcher = new StringEqualMatcher(string);
        matcher.setStringModes(StringMode.SameAsSpace);
        return (E)((ICharAssert)this.assertThat((Matcher)matcher));
    }

    default public E notBlank() {
        StringNotBlankMatcher matcher = new StringNotBlankMatcher();
        return (E)((ICharAssert)this.assertThat("expect string is blank", (Matcher)matcher));
    }
}

