/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.iassert.interal;

import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;
import org.test4j.hamcrest.iassert.interal.IAssert;
import org.test4j.hamcrest.iassert.interal.MatcherHelper;
import org.test4j.hamcrest.matcher.mockito.GreaterOrEqual;
import org.test4j.hamcrest.matcher.mockito.GreaterThan;
import org.test4j.hamcrest.matcher.mockito.LessOrEqual;
import org.test4j.hamcrest.matcher.mockito.LessThan;

public interface IComparableAssert<T, E extends IComparableAssert>
extends IAssert<T, E> {
    default public E isLt(T max) {
        MatcherHelper.assetCanComparable(max);
        LessThan matcher = new LessThan((Comparable)max);
        return (E)((IComparableAssert)this.assertThat((Matcher)matcher));
    }

    default public E isLe(T max) {
        MatcherHelper.assetCanComparable(max);
        LessOrEqual matcher = new LessOrEqual((Comparable)max);
        return (E)((IComparableAssert)this.assertThat((Matcher)matcher));
    }

    default public E isGt(T min) {
        MatcherHelper.assetCanComparable(min);
        GreaterThan matcher = new GreaterThan((Comparable)min);
        return (E)((IComparableAssert)this.assertThat((Matcher)matcher));
    }

    default public E isGe(T min) {
        MatcherHelper.assetCanComparable(min);
        GreaterOrEqual matcher = new GreaterOrEqual((Comparable)min);
        return (E)((IComparableAssert)this.assertThat((Matcher)matcher));
    }

    default public E isBetween(T min, T max) {
        MatcherHelper.assetCanComparable(min);
        MatcherHelper.assetCanComparable(max);
        if (((Comparable)min).compareTo((Comparable)max) > 0) {
            throw new AssertionError((Object)String.format("arg1[%s] must less than arg2[%s]", min, max));
        }
        GreaterOrEqual geq = new GreaterOrEqual((Comparable)min);
        LessOrEqual leq = new LessOrEqual((Comparable)max);
        Matcher matcher = AllOf.allOf((Matcher[])new Matcher[]{geq, leq});
        return (E)((IComparableAssert)this.assertThat(matcher));
    }

    default public E isLessThan(T max) {
        return this.isLt(max);
    }

    default public E isLessEqual(T max) {
        return this.isLe(max);
    }

    default public E isGreaterThan(T min) {
        return this.isGt(min);
    }

    default public E isGreaterEqual(T min) {
        return this.isGe(min);
    }
}

