/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.iassert.interal;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.collection.ArrayMatching;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.AnyOf;
import org.hamcrest.core.IsIterableContaining;
import org.test4j.hamcrest.iassert.interal.IAssert;
import org.test4j.hamcrest.iassert.interal.MatcherHelper;
import org.test4j.hamcrest.matcher.modes.ItemsMode;
import org.test4j.hamcrest.matcher.modes.MatchMode;

public interface IListHasItemsAssert<T, E extends IAssert>
extends IAssert<T, E> {
    default public E hasAllItems(Object item, Object ... items) {
        this.getAssertObject().assertTargetClassNotNull();
        boolean isArr = this.getAssertObject().valueIsArray();
        List<Matcher<T[]>> list = MatcherHelper.getHasItemMatchers(isArr, item, items);
        Matcher matcher = AllOf.allOf(list);
        return this.assertThat(matcher);
    }

    default public E hasItems(Object value) {
        this.getAssertObject().assertTargetClassNotNull();
        if (this.getAssertObject().valueIsArray()) {
            return this.assertThat(ArrayMatching.hasItemInArray((Object)value));
        }
        return this.assertThat(IsIterableContaining.hasItem((Object)value));
    }

    default public E hasItems(Object item, Object ... items) {
        return this.hasAllItems(item, items);
    }

    default public E hasAnyItems(Object item, Object ... items) {
        this.getAssertObject().assertTargetClassNotNull();
        boolean isArr = this.getAssertObject().valueIsArray();
        List<Matcher<T[]>> list = MatcherHelper.getHasItemMatchers(isArr, item, items);
        AnyOf matcher = AnyOf.anyOf(list);
        return this.assertThat((Matcher)matcher);
    }

    default public E allItemsMatchAll(Matcher matcher, Matcher ... matchers) {
        List list = MatcherHelper.getItemsMatchers(ItemsMode.AllItems, matcher, matchers);
        return this.assertThat(AllOf.allOf(list));
    }

    default public E allItemsMatchAny(Matcher matcher, Matcher ... matchers) {
        List list = MatcherHelper.getItemsMatchers(ItemsMode.AllItems, matcher, matchers);
        return this.assertThat((Matcher)AnyOf.anyOf(list));
    }

    default public E anyItemsMatchAll(Matcher matcher, Matcher ... matchers) {
        Matcher m = MatcherHelper.getAnyItemsMatchAll(matcher, matchers);
        return this.assertThat(m);
    }

    default public E anyItemsMatchAny(Matcher matcher, Matcher ... matchers) {
        List list = MatcherHelper.getItemsMatchers(ItemsMode.AnyItems, matcher, matchers);
        return this.assertThat((Matcher)AnyOf.anyOf(list));
    }

    default public E match(ItemsMode itemsMode, MatchMode matchMode, Matcher matcher, Matcher ... matchers) {
        if (itemsMode == ItemsMode.AllItems && matchMode == MatchMode.MatchAll) {
            return this.allItemsMatchAll(matcher, matchers);
        }
        if (itemsMode == ItemsMode.AllItems && matchMode == MatchMode.MatchAny) {
            return this.allItemsMatchAny(matcher, matchers);
        }
        if (itemsMode == ItemsMode.AnyItems && matchMode == MatchMode.MatchAll) {
            return this.anyItemsMatchAll(matcher, matchers);
        }
        if (itemsMode == ItemsMode.AnyItems && matchMode == MatchMode.MatchAny) {
            return this.anyItemsMatchAny(matcher, matchers);
        }
        throw new RuntimeException("the arguments[ItmesMode and MatchMode] of items match API can't be null.");
    }
}

