/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.iassert.interal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.collection.ArrayMatching;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.IsIterableContaining;
import org.test4j.hamcrest.matcher.array.ListEveryItemMatcher;
import org.test4j.hamcrest.matcher.modes.ItemsMode;

public class MatcherHelper {
    public static <T> List<Matcher<? super T[]>> getHasItemMatchers(boolean isArr, Object item, Object ... items) {
        ArrayList<Matcher<? super T[]>> list = new ArrayList<Matcher<? super T[]>>();
        list.add(MatcherHelper.buildArrayMatcher(isArr, item));
        if (items != null) {
            Arrays.stream(items).map(_item -> MatcherHelper.buildArrayMatcher(isArr, _item)).forEach(list::add);
        }
        return list;
    }

    private static <T> Matcher buildArrayMatcher(boolean isArr, Object item) {
        return isArr ? ArrayMatching.hasItemInArray((Object)item) : IsIterableContaining.hasItem((Object)item);
    }

    public static <T> List<Matcher<? super T>> getItemsMatchers(ItemsMode itemsMode, Matcher matcher, Matcher ... matchers) {
        ArrayList list = new ArrayList();
        list.add((Matcher<T>)new ListEveryItemMatcher(matcher, itemsMode));
        if (matchers != null && matchers.length > 0) {
            Arrays.stream(matchers).forEach(m -> list.add((Matcher)new ListEveryItemMatcher((Matcher)m, itemsMode)));
        }
        return list;
    }

    public static <T> Matcher getAnyItemsMatchAll(Matcher matcher, Matcher ... matchers) {
        ArrayList<Matcher> list = new ArrayList<Matcher>();
        list.add(matcher);
        for (Matcher m : matchers) {
            list.add(m);
        }
        Matcher allItems = AllOf.allOf(list);
        return new ListEveryItemMatcher(allItems, ItemsMode.AnyItems);
    }

    public static <T> void assetCanComparable(T o) {
        if (o != null && !(o instanceof Comparable)) {
            throw new AssertionError((Object)("the object[" + o + "] isn't a comparable object."));
        }
    }
}

