/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.matcher.array;

import java.util.List;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.test4j.hamcrest.matcher.modes.ItemsMode;
import org.test4j.tools.commons.ListHelper;

public class ListEveryItemMatcher
extends BaseMatcher {
    private Matcher matcher = null;
    private ItemsMode itemsMode = null;

    public ListEveryItemMatcher(Matcher matcher, ItemsMode itemsMode) {
        this.matcher = matcher;
        this.itemsMode = itemsMode;
    }

    public boolean matches(Object actual) {
        if (actual == null) {
            return false;
        }
        List _actual = ListHelper.toList(actual, true);
        for (Object item : _actual) {
            boolean match = false;
            if (item != null) {
                match = this.matcher.matches(item);
            }
            if (!match && this.itemsMode == ItemsMode.AllItems) {
                return false;
            }
            if (!match || this.itemsMode != ItemsMode.AnyItems) continue;
            return true;
        }
        return this.itemsMode == ItemsMode.AllItems;
    }

    public void describeTo(Description description) {
        if (this.itemsMode == ItemsMode.AllItems) {
            description.appendText("all of item is ");
        } else {
            description.appendText("any of item is ");
        }
        description.appendDescriptionOf((SelfDescribing)this.matcher);
    }
}

