/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.matcher.array;

import java.util.Collection;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.test4j.tools.commons.ArrayHelper;

public class SizeOrLengthMatcher
extends BaseMatcher<Collection<?>> {
    private int size;
    private SizeOrLengthMatcherType type;
    int actualSize = 0;

    public SizeOrLengthMatcher(int size, SizeOrLengthMatcherType type) {
        this.size = size;
        this.type = type;
    }

    public boolean matches(Object actual) {
        if (actual == null) {
            return false;
        }
        this.actualSize = ArrayHelper.sizeOf(actual);
        switch (this.type) {
            case EQ: {
                return this.actualSize == this.size;
            }
            case GT: {
                return this.actualSize > this.size;
            }
            case GE: {
                return this.actualSize >= this.size;
            }
            case LT: {
                return this.actualSize < this.size;
            }
            case LE: {
                return this.actualSize <= this.size;
            }
        }
        return this.actualSize != this.size;
    }

    public void describeTo(Description description) {
        description.appendText(String.format(this.type.description(), this.size));
        description.appendText(", but actual size is[" + this.actualSize + "].");
    }

    public static enum SizeOrLengthMatcherType {
        EQ{

            @Override
            public String description() {
                return "size of collection or array must equal to %d";
            }
        }
        ,
        GT{

            @Override
            public String description() {
                return "size of collection or array must be greater then %d";
            }
        }
        ,
        GE{

            @Override
            public String description() {
                return "size of collection or array must equal to or greater then %d";
            }
        }
        ,
        LT{

            @Override
            public String description() {
                return "size of collection or array must be less then %d";
            }
        }
        ,
        LE{

            @Override
            public String description() {
                return "size of collection or array must equal to or less then %d";
            }
        }
        ,
        NE{

            @Override
            public String description() {
                return "size of collection or array must not equal to %d";
            }
        };


        public abstract String description();
    }
}

