/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.matcher.calendar;

import java.util.Calendar;
import java.util.Date;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class DateParterMatcher
extends BaseMatcher<Date> {
    private int expected;
    private DateFieldType type;

    public DateParterMatcher(int expected, DateFieldType type) {
        this.expected = expected;
        this.type = type;
    }

    public boolean matches(Object actual) {
        if (actual == null) {
            throw new AssertionError((Object)"the actual value can't be null");
        }
        Calendar cal = null;
        if (actual instanceof Calendar) {
            cal = (Calendar)actual;
        } else if (actual instanceof Date) {
            cal = Calendar.getInstance();
            cal.setTime((Date)actual);
        } else {
            throw new AssertionError((Object)"the actual value must be a java.util.Date instance or a java.util.Calendar instance");
        }
        int value = cal.get(this.type.calendarField());
        if (this.type == DateFieldType.MONTH) {
            return this.expected == value + 1;
        }
        return this.expected == value;
    }

    public void describeTo(Description description) {
        description.appendText(String.format(this.type.description(), this.expected));
    }

    public static enum DateFieldType {
        YEAR{

            @Override
            public int calendarField() {
                return 1;
            }

            @Override
            public String description() {
                return "the year of expected time must equal to %d";
            }
        }
        ,
        MONTH{

            @Override
            public int calendarField() {
                return 2;
            }

            @Override
            public String description() {
                return "the month of expected time must equal to %d";
            }
        }
        ,
        DATE{

            @Override
            public int calendarField() {
                return 5;
            }

            @Override
            public String description() {
                return "the day/month of expected time must equal to %d";
            }
        }
        ,
        HOUR{

            @Override
            public int calendarField() {
                return 11;
            }

            @Override
            public String description() {
                return "the hour of expected time must equal to %d";
            }
        }
        ,
        MINUTE{

            @Override
            public int calendarField() {
                return 12;
            }

            @Override
            public String description() {
                return "the minute of expected time must equal to %d";
            }
        }
        ,
        SECOND{

            @Override
            public int calendarField() {
                return 13;
            }

            @Override
            public String description() {
                return "the second of expected time must equal to %d";
            }
        };


        public abstract int calendarField();

        public abstract String description();
    }
}

