/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.matcher.file;

import java.io.File;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class FileExistsMatcher
extends BaseMatcher<File> {
    private File expected;
    private FileExistsMatcherType type;

    public FileExistsMatcher(File file, FileExistsMatcherType type) {
        this.expected = file;
        this.type = type;
    }

    public boolean matches(Object actual) {
        if (this.type == FileExistsMatcherType.ISEXISTS) {
            return this.expected.exists();
        }
        return !this.expected.exists();
    }

    public void describeTo(Description description) {
        description.appendText(String.format(this.type.description(), this.expected.getAbsolutePath()));
    }

    public static enum FileExistsMatcherType {
        ISEXISTS{

            @Override
            public String description() {
                return "file '%s' has existed";
            }
        }
        ,
        UNEXISTS{

            @Override
            public String description() {
                return "file '%s' doesn't exist";
            }
        };


        public abstract String description();
    }
}

