/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.matcher.file;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsEqual;

public class FileMatchers {
    public static Matcher<File> isDirectory() {
        return new TypeSafeMatcher<File>(){
            File fileTested;

            public boolean matchesSafely(File item) {
                this.fileTested = item;
                return item.isDirectory();
            }

            public void describeTo(Description description) {
                description.appendText(" that ");
                description.appendValue((Object)this.fileTested);
                description.appendText("is a directory");
            }
        };
    }

    public static Matcher<File> exists() {
        return new TypeSafeMatcher<File>(){
            File fileTested;

            public boolean matchesSafely(File item) {
                this.fileTested = item;
                return item.exists();
            }

            public void describeTo(Description description) {
                description.appendText(" that file ");
                description.appendValue((Object)this.fileTested);
                description.appendText(" exists");
            }
        };
    }

    public static Matcher<File> isFile() {
        return new TypeSafeMatcher<File>(){
            File fileTested;

            public boolean matchesSafely(File item) {
                this.fileTested = item;
                return item.isFile();
            }

            public void describeTo(Description description) {
                description.appendText(" that ");
                description.appendValue((Object)this.fileTested);
                description.appendText("is a file");
            }
        };
    }

    public static Matcher<File> readable() {
        return new TypeSafeMatcher<File>(){
            File fileTested;

            public boolean matchesSafely(File item) {
                this.fileTested = item;
                return item.canRead();
            }

            public void describeTo(Description description) {
                description.appendText(" that file ");
                description.appendValue((Object)this.fileTested);
                description.appendText("is readable");
            }
        };
    }

    public static Matcher<File> writable() {
        return new TypeSafeMatcher<File>(){
            File fileTested;

            public boolean matchesSafely(File item) {
                this.fileTested = item;
                return item.canWrite();
            }

            public void describeTo(Description description) {
                description.appendText(" that file ");
                description.appendValue((Object)this.fileTested);
                description.appendText("is writable");
            }
        };
    }

    public static Matcher<File> sized(long size) {
        Matcher matcher = IsEqual.equalTo((Object)size);
        return FileMatchers.sized(matcher);
    }

    public static Matcher<File> sized(final Matcher matcher) {
        return new TypeSafeMatcher<File>(){
            File fileTested;
            long length;

            public boolean matchesSafely(File item) {
                this.fileTested = item;
                this.length = item.length();
                return matcher.matches((Object)this.length);
            }

            public void describeTo(Description description) {
                description.appendText(" that file ");
                description.appendValue((Object)this.fileTested);
                description.appendText(" is sized ");
                description.appendDescriptionOf((SelfDescribing)matcher);
                description.appendText(", not " + this.length);
            }
        };
    }

    public static Matcher<File> nameEq(final String name) {
        return new TypeSafeMatcher<File>(){
            File fileTested;

            public boolean matchesSafely(File item) {
                this.fileTested = item;
                String filename = item == null ? null : item.getName();
                return name.equals(filename);
            }

            public void describeTo(Description description) {
                description.appendText(" that file name of ");
                description.appendValue((Object)this.fileTested);
                description.appendText(" expected equals to ");
                description.appendValue((Object)name);
                description.appendText(", but actual not!");
            }
        };
    }

    public static Matcher<File> nameContain(final String name) {
        return new TypeSafeMatcher<File>(){
            File fileTested;

            public boolean matchesSafely(File item) {
                this.fileTested = item;
                String filename = item == null ? null : item.getName();
                return filename != null && filename.indexOf(name) != -1;
            }

            public void describeTo(Description description) {
                description.appendText(" that file name of ");
                description.appendValue((Object)this.fileTested);
                description.appendText(" expected to contain ");
                description.appendValue((Object)name);
                description.appendText(", but actual not!");
            }
        };
    }

    public static Matcher<File> named(final Matcher<String> name) {
        return new TypeSafeMatcher<File>(){
            File fileTested;

            public boolean matchesSafely(File item) {
                this.fileTested = item;
                return name.matches((Object)item.getName());
            }

            public void describeTo(Description description) {
                description.appendText(" that file ");
                description.appendValue((Object)this.fileTested);
                description.appendText(" is named");
                description.appendDescriptionOf((SelfDescribing)name);
                description.appendText(" not ");
                description.appendValue((Object)this.fileTested.getName());
            }
        };
    }

    public static Matcher<File> withCanonicalPath(final Matcher<String> path) {
        return new TypeSafeMatcher<File>(){

            public boolean matchesSafely(File item) {
                try {
                    return path.matches((Object)item.getCanonicalPath());
                }
                catch (IOException e) {
                    return false;
                }
            }

            public void describeTo(Description description) {
                description.appendText("with canonical path '");
                description.appendDescriptionOf((SelfDescribing)path);
                description.appendText("'");
            }
        };
    }

    public static Matcher<File> withAbsolutePath(final Matcher path) {
        return new TypeSafeMatcher<File>(){

            public boolean matchesSafely(File item) {
                return path.matches((Object)item.getAbsolutePath());
            }

            public void describeTo(Description description) {
                description.appendText("with absolute path '");
                description.appendDescriptionOf((SelfDescribing)path);
                description.appendText("'");
            }
        };
    }
}

