/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.matcher.property;

import java.util.List;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.test4j.tools.commons.ArrayHelper;
import org.test4j.tools.commons.ListHelper;
import org.test4j.tools.reflector.PropertyAccessor;

public class PropertyAllItemsMatcher
extends BaseMatcher {
    private String property;
    private Matcher matcher;
    private final StringBuilder buff = new StringBuilder();
    private List actualItems;

    public PropertyAllItemsMatcher(String property, Matcher matcher) {
        this.property = property;
        this.matcher = matcher;
        if (this.property == null) {
            throw new RuntimeException("the properties can't be null.");
        }
    }

    public boolean matches(Object actual) {
        if (!ArrayHelper.isCollOrArray(actual)) {
            this.buff.append("PropertyItemsMatcher, the actual value must be a array or collection.");
            return false;
        }
        List list = ListHelper.toList(actual);
        this.actualItems = PropertyAccessor.getPropertyOfList(list, this.property, true);
        for (Object item : this.actualItems) {
            boolean match = this.matcher.matches(item);
            if (match) continue;
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the propery" + this.property + " values of object is:\n");
        description.appendText(ListHelper.toString(this.actualItems)).appendText("\n");
        description.appendDescriptionOf((SelfDescribing)this.matcher);
    }
}

