/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.matcher.string;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.test4j.hamcrest.matcher.string.StringMode;

public class StringContainsInOrder
extends TypeSafeMatcher<String> {
    private final Iterable<String> substrings;
    private final StringMode[] modes;
    String message = "";

    public StringContainsInOrder(Iterable<String> substrings) {
        this.substrings = substrings;
        this.modes = new StringMode[0];
    }

    public StringContainsInOrder(Iterable<String> substrings, StringMode[] modes) {
        this.substrings = substrings;
        this.modes = modes;
    }

    public boolean matchesSafely(String s) {
        if (s == null) {
            this.message = "the actual can't be null.";
            return false;
        }
        String actual = StringMode.getStringByMode(s, this.modes);
        int fromIndex = 0;
        for (String substring : this.substrings) {
            if (substring == null) {
                this.message = "the sub string can't be null.";
                return false;
            }
            String expected = StringMode.getStringByMode(substring, this.modes);
            int index = actual.indexOf(expected, fromIndex);
            if (index == -1) {
                this.message = String.format("the string[%s] not contain substring[%s] from index %d.", actual, expected, fromIndex);
                return false;
            }
            fromIndex = index + expected.length();
        }
        return true;
    }

    public void describeMismatchSafely(String item, Description mismatchDescription) {
        mismatchDescription.appendText("was ").appendText("\"").appendText(item).appendText("\"");
    }

    public void describeTo(Description description) {
        description.appendText("a string containing ").appendValueList("", ", ", "", this.substrings);
        if (this.modes != null && this.modes.length > 0) {
            description.appendText(" in order by modes" + StringMode.toString(this.modes));
        }
        if (!"".endsWith(this.message)) {
            description.appendText(", but ").appendText(this.message);
        }
    }

    public static Matcher<String> stringContainsInOrder(Iterable<String> substrings) {
        return new StringContainsInOrder(substrings);
    }
}

