/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.commons;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class AnnotationHelper {
    public static <T extends Annotation> Set<Field> getFieldsAnnotatedWith(Class<? extends Object> clazz, Class<T> annotation) {
        Field[] fields;
        if (Object.class.equals(clazz)) {
            return Collections.emptySet();
        }
        HashSet<Field> annotatedFields = new HashSet<Field>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            T o = field.getAnnotation(annotation);
            if (o == null) continue;
            annotatedFields.add(field);
        }
        annotatedFields.addAll(AnnotationHelper.getFieldsAnnotatedWith(clazz.getSuperclass(), annotation));
        return annotatedFields;
    }

    public static <T extends Annotation> Set<Method> getMethodsAnnotatedWith(Class clazz, Class<T> annotation) {
        return AnnotationHelper.getMethodsAnnotatedWith(clazz, annotation, true);
    }

    public static <T extends Annotation> Set<Method> getMethodsAnnotatedWith(Class clazz, Class<T> annotation, boolean includeInherited) {
        Method[] methods;
        if (Object.class.equals((Object)clazz)) {
            return Collections.emptySet();
        }
        HashSet<Method> annotatedMethods = new HashSet<Method>();
        for (Method method : methods = clazz.getDeclaredMethods()) {
            T o = method.getAnnotation(annotation);
            if (o == null) continue;
            annotatedMethods.add(method);
        }
        if (includeInherited) {
            annotatedMethods.addAll(AnnotationHelper.getMethodsAnnotatedWith(clazz.getSuperclass(), annotation));
        }
        return annotatedMethods;
    }

    public static <T extends Annotation> T getClassLevelAnnotation(Class<T> annotationClass, Class clazz) {
        if (Object.class.equals((Object)clazz)) {
            return null;
        }
        T annotation = clazz.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        return AnnotationHelper.getClassLevelAnnotation(annotationClass, clazz.getSuperclass());
    }

    public static <S extends Annotation, T> T getMethodOrClassLevelAnnotationProperty(Class<S> annotationClass, String annotationPropertyName, T defaultValue, Method method, Class clazz) {
        T value = AnnotationHelper.getMethodLevelAnnotationProperty(annotationClass, annotationPropertyName, method);
        if (value == null || Objects.equals(value, defaultValue)) {
            return AnnotationHelper.getClassLevelAnnotationProperty(annotationClass, annotationPropertyName, defaultValue, clazz);
        }
        return value;
    }

    private static <S extends Annotation, T> T getMethodLevelAnnotationProperty(Class<S> annotationClass, String annotationPropertyName, Method method) {
        if (method == null) {
            return null;
        }
        S annotation = method.getAnnotation(annotationClass);
        if (annotation == null) {
            return null;
        }
        Method annotationProperty = AnnotationHelper.getAnnotationPropertyWithName(annotationClass, annotationPropertyName);
        return AnnotationHelper.getAnnotationPropertyValue(annotationProperty, annotation);
    }

    public static <S extends Annotation, T> T getClassLevelAnnotationProperty(Class<S> annotationClass, String annotationPropertyName, T defaultValue, Class clazz) {
        Method annotationProperty;
        T propertyValue;
        if (Object.class.equals((Object)clazz)) {
            return defaultValue;
        }
        S annotation = clazz.getAnnotation(annotationClass);
        if (annotation != null && !defaultValue.equals(propertyValue = AnnotationHelper.getAnnotationPropertyValue(annotationProperty = AnnotationHelper.getAnnotationPropertyWithName(annotationClass, annotationPropertyName), annotation))) {
            return propertyValue;
        }
        return AnnotationHelper.getClassLevelAnnotationProperty(annotationClass, annotationPropertyName, defaultValue, clazz.getSuperclass());
    }

    private static Method getAnnotationPropertyWithName(Class<? extends Annotation> annotation, String annotationPropertyName) {
        try {
            return annotation.getMethod(annotationPropertyName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not find annotation property named " + annotationPropertyName + " on annotation " + annotation.getName());
        }
    }

    public static <T> T getAnnotationPropertyValue(Method annotationProperty, Annotation annotation) {
        try {
            return (T)annotationProperty.invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error retrieving value of property " + annotationProperty.getName() + " of annotation of type " + annotation.getClass().getSimpleName(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error retrieving value of property " + annotationProperty.getName() + " of annotation of type " + annotation.getClass().getSimpleName(), e);
        }
    }
}

