/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.commons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.test4j.tools.commons.ArrayHelper;
import org.test4j.tools.reflector.PropertyAccessor;

public class ListHelper {
    public static <T> List toList(T ... objects) {
        List<T> list = new ArrayList();
        if (objects == null || objects.length == 0) {
            return list;
        }
        if (objects.length == 1) {
            list = ListHelper.toList(objects[0], false);
            return list;
        }
        for (T o : objects) {
            list.add(o);
        }
        return list;
    }

    public static List toList(Object object, boolean withMap) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (object == null) {
            list.add(null);
            return list;
        }
        if (object instanceof Collection) {
            list.addAll((Collection)object);
            return list;
        }
        if (object.getClass().isArray()) {
            Object[] array;
            for (Object item : array = ArrayHelper.asArray(object)) {
                list.add(item);
            }
            return list;
        }
        if (withMap && object instanceof Map) {
            Collection values = ((Map)object).values();
            list.addAll(values);
            return list;
        }
        list.add(object);
        return list;
    }

    public static List toList(char[] values) {
        ArrayList<Character> objs = new ArrayList<Character>();
        char[] cArray = values;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character value = Character.valueOf(cArray[i]);
            objs.add(value);
        }
        return objs;
    }

    public static List toList(float[] values) {
        ArrayList<Float> objs = new ArrayList<Float>();
        float[] fArray = values;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            Float value = Float.valueOf(fArray[i]);
            objs.add(value);
        }
        return objs;
    }

    public static List toList(long[] values) {
        ArrayList<Long> objs = new ArrayList<Long>();
        long[] lArray = values;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long value = lArray[i];
            objs.add(value);
        }
        return objs;
    }

    public static List toList(short[] values) {
        ArrayList<Short> objs = new ArrayList<Short>();
        short[] sArray = values;
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            Short value = sArray[i];
            objs.add(value);
        }
        return objs;
    }

    public static List toList(int[] values) {
        ArrayList<Integer> objs = new ArrayList<Integer>();
        int[] nArray = values;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer value = nArray[i];
            objs.add(value);
        }
        return objs;
    }

    public static List toList(double[] values) {
        ArrayList<Double> objs = new ArrayList<Double>();
        double[] dArray = values;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double value = dArray[i];
            objs.add(value);
        }
        return objs;
    }

    public static List toList(boolean[] values) {
        ArrayList<Boolean> objs = new ArrayList<Boolean>();
        boolean[] blArray = values;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            Boolean value = blArray[i];
            objs.add(value);
        }
        return objs;
    }

    public static List toList(byte[] values) {
        ArrayList<Byte> objs = new ArrayList<Byte>();
        byte[] byArray = values;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte value = byArray[i];
            objs.add(value);
        }
        return objs;
    }

    public static boolean isCollection(Object o) {
        if (o == null) {
            return false;
        }
        return o instanceof Collection;
    }

    public static String toString(List list) {
        if (list == null) {
            return "null";
        }
        StringBuilder buff = new StringBuilder("[");
        boolean first = true;
        for (Object o : list) {
            if (first) {
                first = false;
            } else {
                buff.append(", ");
            }
            buff.append(String.valueOf(o));
        }
        buff.append("]");
        return buff.toString();
    }

    public static List<Map<String, ?>> getProperties(List list, Set<String> keys, boolean isExpected) {
        ArrayList result = new ArrayList();
        for (Object o : list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : keys) {
                try {
                    Object value = PropertyAccessor.getPropertyByOgnl(o, key, true);
                    map.put(key, value);
                }
                catch (RuntimeException e) {
                    if (isExpected) {
                        throw e;
                    }
                    map.put(key, null);
                }
            }
            result.add(map);
        }
        return result;
    }
}

