/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.commons;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import org.test4j.Logger;
import org.test4j.tools.commons.ResourceHelper;
import org.test4j.tools.commons.StringHelper;

public class PropertiesReader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties loadPropertiesFileFromUserHome(String propertiesFileName) {
        String userHomeDir = System.getProperty("user.home");
        File localPropertiesFile = new File(userHomeDir, propertiesFileName);
        if (!localPropertiesFile.exists()) {
            return null;
        }
        try (FileInputStream inputStream = new FileInputStream(localPropertiesFile);){
            if ("".equals(propertiesFileName)) {
                throw new IllegalArgumentException("Properties Filename must be given.");
            }
            Properties properties2 = new Properties();
            properties2.load(inputStream);
            Logger.info((Object)("Loaded configuration file " + propertiesFileName + " from user home"), (Throwable[])new Throwable[0]);
            Properties properties = properties2;
            return properties;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to load configuration file: " + propertiesFileName + " from user home", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties loadPropertiesFileFromClasspath(String propertiesFileName) {
        if (StringHelper.isBlank(propertiesFileName)) {
            throw new IllegalArgumentException("Properties Filename must be given.");
        }
        Properties properties2 = new Properties();
        try (InputStream inputStream = ResourceHelper.getResourceAsStream(PropertiesReader.class.getClassLoader(), propertiesFileName);){
            if (inputStream == null) {
                Logger.warn((Object)("No configuration file " + propertiesFileName + " found."), (Throwable[])new Throwable[0]);
            } else {
                properties2.load(inputStream);
            }
            Properties properties = properties2;
            return properties;
        }
        catch (FileNotFoundException e) {
            Logger.warn((Object)("No configuration file " + propertiesFileName + " found."), (Throwable[])new Throwable[0]);
            return properties2;
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to load configuration file: " + propertiesFileName, e);
        }
    }
}

